/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.core.update;

import co.elastic.clients.elasticsearch._types.InlineGet;
import co.elastic.clients.elasticsearch._types.WriteResponseBase;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

public abstract class UpdateWriteResponseBase<TDocument>
extends WriteResponseBase {
    @Nullable
    private final InlineGet<TDocument> get;
    @Nullable
    private final JsonpSerializer<TDocument> tDocumentSerializer;

    protected UpdateWriteResponseBase(AbstractBuilder<TDocument, ?> builder) {
        super(builder);
        this.get = ((AbstractBuilder)builder).get;
        this.tDocumentSerializer = ((AbstractBuilder)builder).tDocumentSerializer;
    }

    @Nullable
    public final InlineGet<TDocument> get() {
        return this.get;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        if (this.get != null) {
            generator.writeKey("get");
            this.get.serialize(generator, mapper);
        }
    }

    protected static <TDocument, BuilderT extends AbstractBuilder<TDocument, BuilderT>> void setupUpdateWriteResponseBaseDeserializer(ObjectDeserializer<BuilderT> op, JsonpDeserializer<TDocument> tDocumentDeserializer) {
        WriteResponseBase.setupWriteResponseBaseDeserializer(op);
        op.add(AbstractBuilder::get, InlineGet.createInlineGetDeserializer(tDocumentDeserializer), "get");
    }

    protected static abstract class AbstractBuilder<TDocument, BuilderT extends AbstractBuilder<TDocument, BuilderT>>
    extends WriteResponseBase.AbstractBuilder<BuilderT> {
        @Nullable
        private InlineGet<TDocument> get;
        @Nullable
        private JsonpSerializer<TDocument> tDocumentSerializer;

        protected AbstractBuilder() {
        }

        public final BuilderT get(@Nullable InlineGet<TDocument> value) {
            this.get = value;
            return (BuilderT)((AbstractBuilder)this.self());
        }

        public final BuilderT get(Function<InlineGet.Builder<TDocument>, ObjectBuilder<InlineGet<TDocument>>> fn) {
            return this.get(fn.apply(new InlineGet.Builder()).build());
        }

        public final BuilderT tDocumentSerializer(@Nullable JsonpSerializer<TDocument> value) {
            this.tDocumentSerializer = value;
            return (BuilderT)((AbstractBuilder)this.self());
        }
    }
}

