/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.core.reindex;

import co.elastic.clients.elasticsearch._types.OpType;
import co.elastic.clients.elasticsearch._types.VersionType;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class Destination
implements JsonpSerializable {
    private final String index;
    @Nullable
    private final OpType opType;
    @Nullable
    private final String pipeline;
    @Nullable
    private final String routing;
    @Nullable
    private final VersionType versionType;
    public static final JsonpDeserializer<Destination> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, Destination::setupDestinationDeserializer);

    private Destination(Builder builder) {
        this.index = ApiTypeHelper.requireNonNull(builder.index, this, "index");
        this.opType = builder.opType;
        this.pipeline = builder.pipeline;
        this.routing = builder.routing;
        this.versionType = builder.versionType;
    }

    public static Destination of(Function<Builder, ObjectBuilder<Destination>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String index() {
        return this.index;
    }

    @Nullable
    public final OpType opType() {
        return this.opType;
    }

    @Nullable
    public final String pipeline() {
        return this.pipeline;
    }

    @Nullable
    public final String routing() {
        return this.routing;
    }

    @Nullable
    public final VersionType versionType() {
        return this.versionType;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("index");
        generator.write(this.index);
        if (this.opType != null) {
            generator.writeKey("op_type");
            this.opType.serialize(generator, mapper);
        }
        if (this.pipeline != null) {
            generator.writeKey("pipeline");
            generator.write(this.pipeline);
        }
        if (this.routing != null) {
            generator.writeKey("routing");
            generator.write(this.routing);
        }
        if (this.versionType != null) {
            generator.writeKey("version_type");
            this.versionType.serialize(generator, mapper);
        }
    }

    protected static void setupDestinationDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::index, JsonpDeserializer.stringDeserializer(), "index");
        op.add(Builder::opType, OpType._DESERIALIZER, "op_type");
        op.add(Builder::pipeline, JsonpDeserializer.stringDeserializer(), "pipeline");
        op.add(Builder::routing, JsonpDeserializer.stringDeserializer(), "routing");
        op.add(Builder::versionType, VersionType._DESERIALIZER, "version_type");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<Destination> {
        private String index;
        @Nullable
        private OpType opType;
        @Nullable
        private String pipeline;
        @Nullable
        private String routing;
        @Nullable
        private VersionType versionType;

        public final Builder index(String value) {
            this.index = value;
            return this;
        }

        public final Builder opType(@Nullable OpType value) {
            this.opType = value;
            return this;
        }

        public final Builder pipeline(@Nullable String value) {
            this.pipeline = value;
            return this;
        }

        public final Builder routing(@Nullable String value) {
            this.routing = value;
            return this;
        }

        public final Builder versionType(@Nullable VersionType value) {
            this.versionType = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public Destination build() {
            this._checkSingleUse();
            return new Destination(this);
        }
    }
}

