/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.core.knn_search;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;

@JsonpDeserializable
public class KnnSearchQuery
implements JsonpSerializable {
    private final String field;
    private final List<Double> queryVector;
    private final long k;
    private final long numCandidates;
    public static final JsonpDeserializer<KnnSearchQuery> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, KnnSearchQuery::setupKnnSearchQueryDeserializer);

    private KnnSearchQuery(Builder builder) {
        this.field = ApiTypeHelper.requireNonNull(builder.field, this, "field");
        this.queryVector = ApiTypeHelper.unmodifiableRequired(builder.queryVector, (Object)this, "queryVector");
        this.k = ApiTypeHelper.requireNonNull(builder.k, this, "k");
        this.numCandidates = ApiTypeHelper.requireNonNull(builder.numCandidates, this, "numCandidates");
    }

    public static KnnSearchQuery of(Function<Builder, ObjectBuilder<KnnSearchQuery>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String field() {
        return this.field;
    }

    public final List<Double> queryVector() {
        return this.queryVector;
    }

    public final long k() {
        return this.k;
    }

    public final long numCandidates() {
        return this.numCandidates;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("field");
        generator.write(this.field);
        if (ApiTypeHelper.isDefined(this.queryVector)) {
            generator.writeKey("query_vector");
            generator.writeStartArray();
            for (Double item0 : this.queryVector) {
                generator.write(item0.doubleValue());
            }
            generator.writeEnd();
        }
        generator.writeKey("k");
        generator.write(this.k);
        generator.writeKey("num_candidates");
        generator.write(this.numCandidates);
    }

    protected static void setupKnnSearchQueryDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::field, JsonpDeserializer.stringDeserializer(), "field");
        op.add(Builder::queryVector, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.doubleDeserializer()), "query_vector");
        op.add(Builder::k, JsonpDeserializer.longDeserializer(), "k");
        op.add(Builder::numCandidates, JsonpDeserializer.longDeserializer(), "num_candidates");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<KnnSearchQuery> {
        private String field;
        private List<Double> queryVector;
        private Long k;
        private Long numCandidates;

        public final Builder field(String value) {
            this.field = value;
            return this;
        }

        public final Builder queryVector(List<Double> list) {
            this.queryVector = Builder._listAddAll(this.queryVector, list);
            return this;
        }

        public final Builder queryVector(Double value, Double ... values) {
            this.queryVector = Builder._listAdd(this.queryVector, value, values);
            return this;
        }

        public final Builder k(long value) {
            this.k = value;
            return this;
        }

        public final Builder numCandidates(long value) {
            this.numCandidates = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public KnnSearchQuery build() {
            this._checkSingleUse();
            return new KnnSearchQuery(this);
        }
    }
}

