/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.core;

import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch._types.InlineScript;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch.core.ScriptsPainlessExecuteResponse;
import co.elastic.clients.elasticsearch.core.scripts_painless_execute.PainlessContextSetup;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.Collections;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class ScriptsPainlessExecuteRequest
extends RequestBase
implements JsonpSerializable {
    @Nullable
    private final String context;
    @Nullable
    private final PainlessContextSetup contextSetup;
    @Nullable
    private final InlineScript script;
    public static final JsonpDeserializer<ScriptsPainlessExecuteRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ScriptsPainlessExecuteRequest::setupScriptsPainlessExecuteRequestDeserializer);
    public static final SimpleEndpoint<ScriptsPainlessExecuteRequest, ?> _ENDPOINT = new SimpleEndpoint<ScriptsPainlessExecuteRequest, ScriptsPainlessExecuteResponse<Object>>("es/scripts_painless_execute", request -> "POST", request -> "/_scripts/painless/_execute", request -> Collections.emptyMap(), SimpleEndpoint.emptyMap(), true, ScriptsPainlessExecuteResponse._DESERIALIZER);

    private ScriptsPainlessExecuteRequest(Builder builder) {
        this.context = builder.context;
        this.contextSetup = builder.contextSetup;
        this.script = builder.script;
    }

    public static ScriptsPainlessExecuteRequest of(Function<Builder, ObjectBuilder<ScriptsPainlessExecuteRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final String context() {
        return this.context;
    }

    @Nullable
    public final PainlessContextSetup contextSetup() {
        return this.contextSetup;
    }

    @Nullable
    public final InlineScript script() {
        return this.script;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.context != null) {
            generator.writeKey("context");
            generator.write(this.context);
        }
        if (this.contextSetup != null) {
            generator.writeKey("context_setup");
            this.contextSetup.serialize(generator, mapper);
        }
        if (this.script != null) {
            generator.writeKey("script");
            this.script.serialize(generator, mapper);
        }
    }

    protected static void setupScriptsPainlessExecuteRequestDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::context, JsonpDeserializer.stringDeserializer(), "context");
        op.add(Builder::contextSetup, PainlessContextSetup._DESERIALIZER, "context_setup");
        op.add(Builder::script, InlineScript._DESERIALIZER, "script");
    }

    public static <TResult> Endpoint<ScriptsPainlessExecuteRequest, ScriptsPainlessExecuteResponse<TResult>, ErrorResponse> createScriptsPainlessExecuteEndpoint(JsonpDeserializer<TResult> tResultDeserializer) {
        return _ENDPOINT.withResponseDeserializer(ScriptsPainlessExecuteResponse.createScriptsPainlessExecuteResponseDeserializer(tResultDeserializer));
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<ScriptsPainlessExecuteRequest> {
        @Nullable
        private String context;
        @Nullable
        private PainlessContextSetup contextSetup;
        @Nullable
        private InlineScript script;

        public final Builder context(@Nullable String value) {
            this.context = value;
            return this;
        }

        public final Builder contextSetup(@Nullable PainlessContextSetup value) {
            this.contextSetup = value;
            return this;
        }

        public final Builder contextSetup(Function<PainlessContextSetup.Builder, ObjectBuilder<PainlessContextSetup>> fn) {
            return this.contextSetup(fn.apply(new PainlessContextSetup.Builder()).build());
        }

        public final Builder script(@Nullable InlineScript value) {
            this.script = value;
            return this;
        }

        public final Builder script(Function<InlineScript.Builder, ObjectBuilder<InlineScript>> fn) {
            return this.script(fn.apply(new InlineScript.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public ScriptsPainlessExecuteRequest build() {
            this._checkSingleUse();
            return new ScriptsPainlessExecuteRequest(this);
        }
    }
}

