/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.query_dsl;

import co.elastic.clients.elasticsearch._types.query_dsl.Intervals;
import co.elastic.clients.elasticsearch._types.query_dsl.IntervalsQuery;
import co.elastic.clients.elasticsearch._types.query_dsl.IntervalsQueryVariant;
import co.elastic.clients.elasticsearch._types.query_dsl.IntervalsVariant;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class IntervalsWildcard
implements IntervalsQueryVariant,
IntervalsVariant,
JsonpSerializable {
    @Nullable
    private final String analyzer;
    private final String pattern;
    @Nullable
    private final String useField;
    public static final JsonpDeserializer<IntervalsWildcard> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, IntervalsWildcard::setupIntervalsWildcardDeserializer);

    private IntervalsWildcard(Builder builder) {
        this.analyzer = builder.analyzer;
        this.pattern = ApiTypeHelper.requireNonNull(builder.pattern, this, "pattern");
        this.useField = builder.useField;
    }

    public static IntervalsWildcard of(Function<Builder, ObjectBuilder<IntervalsWildcard>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public IntervalsQuery.Kind _intervalsQueryKind() {
        return IntervalsQuery.Kind.Wildcard;
    }

    @Override
    public Intervals.Kind _intervalsKind() {
        return Intervals.Kind.Wildcard;
    }

    @Nullable
    public final String analyzer() {
        return this.analyzer;
    }

    public final String pattern() {
        return this.pattern;
    }

    @Nullable
    public final String useField() {
        return this.useField;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.analyzer != null) {
            generator.writeKey("analyzer");
            generator.write(this.analyzer);
        }
        generator.writeKey("pattern");
        generator.write(this.pattern);
        if (this.useField != null) {
            generator.writeKey("use_field");
            generator.write(this.useField);
        }
    }

    protected static void setupIntervalsWildcardDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::analyzer, JsonpDeserializer.stringDeserializer(), "analyzer");
        op.add(Builder::pattern, JsonpDeserializer.stringDeserializer(), "pattern");
        op.add(Builder::useField, JsonpDeserializer.stringDeserializer(), "use_field");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<IntervalsWildcard> {
        @Nullable
        private String analyzer;
        private String pattern;
        @Nullable
        private String useField;

        public final Builder analyzer(@Nullable String value) {
            this.analyzer = value;
            return this;
        }

        public final Builder pattern(String value) {
            this.pattern = value;
            return this;
        }

        public final Builder useField(@Nullable String value) {
            this.useField = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public IntervalsWildcard build() {
            this._checkSingleUse();
            return new IntervalsWildcard(this);
        }
    }
}

