/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types;

import co.elastic.clients.elasticsearch._types.ErrorCause;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class TaskFailure
implements JsonpSerializable {
    private final long taskId;
    private final String nodeId;
    private final String status;
    private final ErrorCause reason;
    public static final JsonpDeserializer<TaskFailure> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, TaskFailure::setupTaskFailureDeserializer);

    private TaskFailure(Builder builder) {
        this.taskId = ApiTypeHelper.requireNonNull(builder.taskId, this, "taskId");
        this.nodeId = ApiTypeHelper.requireNonNull(builder.nodeId, this, "nodeId");
        this.status = ApiTypeHelper.requireNonNull(builder.status, this, "status");
        this.reason = ApiTypeHelper.requireNonNull(builder.reason, this, "reason");
    }

    public static TaskFailure of(Function<Builder, ObjectBuilder<TaskFailure>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final long taskId() {
        return this.taskId;
    }

    public final String nodeId() {
        return this.nodeId;
    }

    public final String status() {
        return this.status;
    }

    public final ErrorCause reason() {
        return this.reason;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("task_id");
        generator.write(this.taskId);
        generator.writeKey("node_id");
        generator.write(this.nodeId);
        generator.writeKey("status");
        generator.write(this.status);
        generator.writeKey("reason");
        this.reason.serialize(generator, mapper);
    }

    protected static void setupTaskFailureDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::taskId, JsonpDeserializer.longDeserializer(), "task_id");
        op.add(Builder::nodeId, JsonpDeserializer.stringDeserializer(), "node_id");
        op.add(Builder::status, JsonpDeserializer.stringDeserializer(), "status");
        op.add(Builder::reason, ErrorCause._DESERIALIZER, "reason");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<TaskFailure> {
        private Long taskId;
        private String nodeId;
        private String status;
        private ErrorCause reason;

        public final Builder taskId(long value) {
            this.taskId = value;
            return this;
        }

        public final Builder nodeId(String value) {
            this.nodeId = value;
            return this;
        }

        public final Builder status(String value) {
            this.status = value;
            return this;
        }

        public final Builder reason(ErrorCause value) {
            this.reason = value;
            return this;
        }

        public final Builder reason(Function<ErrorCause.Builder, ObjectBuilder<ErrorCause>> fn) {
            return this.reason(fn.apply(new ErrorCause.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public TaskFailure build() {
            this._checkSingleUse();
            return new TaskFailure(this);
        }
    }
}

