/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.indices.put_data_stream_settings;

import co.elastic.clients.elasticsearch.indices.IndexSettings;
import co.elastic.clients.elasticsearch.indices.put_data_stream_settings.IndexSettingResults;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class UpdatedDataStreamSettings
implements JsonpSerializable {
    private final String name;
    private final boolean appliedToDataStream;
    @Nullable
    private final String error;
    private final IndexSettings settings;
    private final IndexSettings effectiveSettings;
    private final IndexSettingResults indexSettingsResults;
    public static final JsonpDeserializer<UpdatedDataStreamSettings> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, UpdatedDataStreamSettings::setupUpdatedDataStreamSettingsDeserializer);

    private UpdatedDataStreamSettings(Builder builder) {
        this.name = ApiTypeHelper.requireNonNull(builder.name, this, "name");
        this.appliedToDataStream = ApiTypeHelper.requireNonNull(builder.appliedToDataStream, (Object)this, "appliedToDataStream", false);
        this.error = builder.error;
        this.settings = ApiTypeHelper.requireNonNull(builder.settings, this, "settings");
        this.effectiveSettings = ApiTypeHelper.requireNonNull(builder.effectiveSettings, this, "effectiveSettings");
        this.indexSettingsResults = ApiTypeHelper.requireNonNull(builder.indexSettingsResults, this, "indexSettingsResults");
    }

    public static UpdatedDataStreamSettings of(Function<Builder, ObjectBuilder<UpdatedDataStreamSettings>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String name() {
        return this.name;
    }

    public final boolean appliedToDataStream() {
        return this.appliedToDataStream;
    }

    @Nullable
    public final String error() {
        return this.error;
    }

    public final IndexSettings settings() {
        return this.settings;
    }

    public final IndexSettings effectiveSettings() {
        return this.effectiveSettings;
    }

    public final IndexSettingResults indexSettingsResults() {
        return this.indexSettingsResults;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("name");
        generator.write(this.name);
        generator.writeKey("applied_to_data_stream");
        generator.write(this.appliedToDataStream);
        if (this.error != null) {
            generator.writeKey("error");
            generator.write(this.error);
        }
        generator.writeKey("settings");
        this.settings.serialize(generator, mapper);
        generator.writeKey("effective_settings");
        this.effectiveSettings.serialize(generator, mapper);
        generator.writeKey("index_settings_results");
        this.indexSettingsResults.serialize(generator, mapper);
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupUpdatedDataStreamSettingsDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::name, JsonpDeserializer.stringDeserializer(), "name");
        op.add(Builder::appliedToDataStream, JsonpDeserializer.booleanDeserializer(), "applied_to_data_stream");
        op.add(Builder::error, JsonpDeserializer.stringDeserializer(), "error");
        op.add(Builder::settings, IndexSettings._DESERIALIZER, "settings");
        op.add(Builder::effectiveSettings, IndexSettings._DESERIALIZER, "effective_settings");
        op.add(Builder::indexSettingsResults, IndexSettingResults._DESERIALIZER, "index_settings_results");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<UpdatedDataStreamSettings> {
        private String name;
        private Boolean appliedToDataStream;
        @Nullable
        private String error;
        private IndexSettings settings;
        private IndexSettings effectiveSettings;
        private IndexSettingResults indexSettingsResults;

        public final Builder name(String value) {
            this.name = value;
            return this;
        }

        public final Builder appliedToDataStream(boolean value) {
            this.appliedToDataStream = value;
            return this;
        }

        public final Builder error(@Nullable String value) {
            this.error = value;
            return this;
        }

        public final Builder settings(IndexSettings value) {
            this.settings = value;
            return this;
        }

        public final Builder settings(Function<IndexSettings.Builder, ObjectBuilder<IndexSettings>> fn) {
            return this.settings(fn.apply(new IndexSettings.Builder()).build());
        }

        public final Builder effectiveSettings(IndexSettings value) {
            this.effectiveSettings = value;
            return this;
        }

        public final Builder effectiveSettings(Function<IndexSettings.Builder, ObjectBuilder<IndexSettings>> fn) {
            return this.effectiveSettings(fn.apply(new IndexSettings.Builder()).build());
        }

        public final Builder indexSettingsResults(IndexSettingResults value) {
            this.indexSettingsResults = value;
            return this;
        }

        public final Builder indexSettingsResults(Function<IndexSettingResults.Builder, ObjectBuilder<IndexSettingResults>> fn) {
            return this.indexSettingsResults(fn.apply(new IndexSettingResults.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public UpdatedDataStreamSettings build() {
            this._checkSingleUse();
            return new UpdatedDataStreamSettings(this);
        }
    }
}

