/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.watcher;

import co.elastic.clients.elasticsearch.watcher.execute_watch.WatchRecord;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class ExecuteWatchResponse
implements JsonpSerializable {
    private final String id;
    private final WatchRecord watchRecord;
    public static final JsonpDeserializer<ExecuteWatchResponse> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ExecuteWatchResponse::setupExecuteWatchResponseDeserializer);

    private ExecuteWatchResponse(Builder builder) {
        this.id = ApiTypeHelper.requireNonNull(builder.id, this, "id");
        this.watchRecord = ApiTypeHelper.requireNonNull(builder.watchRecord, this, "watchRecord");
    }

    public static ExecuteWatchResponse of(Function<Builder, ObjectBuilder<ExecuteWatchResponse>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String id() {
        return this.id;
    }

    public final WatchRecord watchRecord() {
        return this.watchRecord;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("_id");
        generator.write(this.id);
        generator.writeKey("watch_record");
        this.watchRecord.serialize(generator, mapper);
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupExecuteWatchResponseDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::id, JsonpDeserializer.stringDeserializer(), "_id");
        op.add(Builder::watchRecord, WatchRecord._DESERIALIZER, "watch_record");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<ExecuteWatchResponse> {
        private String id;
        private WatchRecord watchRecord;

        public final Builder id(String value) {
            this.id = value;
            return this;
        }

        public final Builder watchRecord(WatchRecord value) {
            this.watchRecord = value;
            return this;
        }

        public final Builder watchRecord(Function<WatchRecord.Builder, ObjectBuilder<WatchRecord>> fn) {
            return this.watchRecord(fn.apply(new WatchRecord.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public ExecuteWatchResponse build() {
            this._checkSingleUse();
            return new ExecuteWatchResponse(this);
        }
    }
}

