/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.inference;

import co.elastic.clients.json.JsonData;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class CustomResponseParams
implements JsonpSerializable {
    private final JsonData jsonParser;
    public static final JsonpDeserializer<CustomResponseParams> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, CustomResponseParams::setupCustomResponseParamsDeserializer);

    private CustomResponseParams(Builder builder) {
        this.jsonParser = ApiTypeHelper.requireNonNull(builder.jsonParser, this, "jsonParser");
    }

    public static CustomResponseParams of(Function<Builder, ObjectBuilder<CustomResponseParams>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final JsonData jsonParser() {
        return this.jsonParser;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("json_parser");
        this.jsonParser.serialize(generator, mapper);
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupCustomResponseParamsDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::jsonParser, JsonData._DESERIALIZER, "json_parser");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<CustomResponseParams> {
        private JsonData jsonParser;

        public final Builder jsonParser(JsonData value) {
            this.jsonParser = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public CustomResponseParams build() {
            this._checkSingleUse();
            return new CustomResponseParams(this);
        }
    }
}

