/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.security;

import co.elastic.clients.elasticsearch.security.FieldRuleVariant;
import co.elastic.clients.elasticsearch.security.RoleMappingRule;
import co.elastic.clients.elasticsearch.security.RoleMappingRuleVariant;
import co.elastic.clients.json.JsonData;
import co.elastic.clients.json.JsonEnum;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.OpenTaggedUnion;
import co.elastic.clients.util.TaggedUnionUtils;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import jakarta.json.stream.JsonParser;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class FieldRule
implements OpenTaggedUnion<Kind, Object>,
RoleMappingRuleVariant,
JsonpSerializable {
    private final Kind _kind;
    private final Object _value;
    @Nullable
    private final String _customKind;
    public static final JsonpDeserializer<FieldRule> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, FieldRule::setupFieldRuleDeserializer, Builder::build);

    @Override
    public RoleMappingRule.Kind _roleMappingRuleKind() {
        return RoleMappingRule.Kind.Field;
    }

    @Override
    public final Kind _kind() {
        return this._kind;
    }

    @Override
    public final Object _get() {
        return this._value;
    }

    public FieldRule(FieldRuleVariant value) {
        this._kind = ApiTypeHelper.requireNonNull(value._fieldRuleKind(), this, "<variant kind>");
        this._value = ApiTypeHelper.requireNonNull(value, this, "<variant value>");
        this._customKind = null;
    }

    private FieldRule(Builder builder) {
        this._kind = ApiTypeHelper.requireNonNull(builder._kind, builder, "<variant kind>");
        this._value = ApiTypeHelper.requireNonNull(builder._value, builder, "<variant value>");
        this._customKind = builder._customKind;
    }

    public static FieldRule of(Function<Builder, ObjectBuilder<FieldRule>> fn) {
        return fn.apply(new Builder()).build();
    }

    public boolean isUsername() {
        return this._kind == Kind.Username;
    }

    public List<String> username() {
        return (List)TaggedUnionUtils.get(this, Kind.Username);
    }

    public boolean isDn() {
        return this._kind == Kind.Dn;
    }

    public List<String> dn() {
        return (List)TaggedUnionUtils.get(this, Kind.Dn);
    }

    public boolean isGroups() {
        return this._kind == Kind.Groups;
    }

    public List<String> groups() {
        return (List)TaggedUnionUtils.get(this, Kind.Groups);
    }

    public boolean _isCustom() {
        return this._kind == Kind._Custom;
    }

    @Override
    @Nullable
    public final String _customKind() {
        return this._customKind;
    }

    public JsonData _custom() {
        return (JsonData)TaggedUnionUtils.get(this, Kind._Custom);
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        generator.writeKey(this._kind == Kind._Custom ? this._customKind : this._kind.jsonValue());
        if (this._value instanceof JsonpSerializable) {
            ((JsonpSerializable)this._value).serialize(generator, mapper);
        } else {
            switch (this._kind) {
                case Username: {
                    generator.writeStartArray();
                    for (String item0 : (List)this._value) {
                        generator.write(item0);
                    }
                    generator.writeEnd();
                    break;
                }
                case Dn: {
                    generator.writeStartArray();
                    for (String item0 : (List)this._value) {
                        generator.write(item0);
                    }
                    generator.writeEnd();
                    break;
                }
                case Groups: {
                    generator.writeStartArray();
                    for (String item0 : (List)this._value) {
                        generator.write(item0);
                    }
                    generator.writeEnd();
                }
            }
        }
        generator.writeEnd();
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupFieldRuleDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::username, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "username");
        op.add(Builder::dn, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "dn");
        op.add(Builder::groups, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "groups");
        op.setUnknownFieldHandler((builder, name, parser, mapper) -> {
            JsonpUtils.ensureCustomVariantsAllowed(parser, mapper);
            builder._custom((String)name, JsonData._DESERIALIZER.deserialize((JsonParser)parser, (JsonpMapper)mapper));
        });
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<FieldRule> {
        private Kind _kind;
        private Object _value;
        private String _customKind;

        @Override
        protected Builder self() {
            return this;
        }

        public ObjectBuilder<FieldRule> username(List<String> v) {
            this._kind = Kind.Username;
            this._value = v;
            return this;
        }

        public ObjectBuilder<FieldRule> dn(List<String> v) {
            this._kind = Kind.Dn;
            this._value = v;
            return this;
        }

        public ObjectBuilder<FieldRule> groups(List<String> v) {
            this._kind = Kind.Groups;
            this._value = v;
            return this;
        }

        public ObjectBuilder<FieldRule> _custom(String name, Object data) {
            this._kind = Kind._Custom;
            this._customKind = name;
            this._value = JsonData.of(data);
            return this;
        }

        @Override
        public FieldRule build() {
            this._checkSingleUse();
            return new FieldRule(this);
        }
    }

    public static enum Kind implements JsonEnum
    {
        Username("username"),
        Dn("dn"),
        Groups("groups"),
        _Custom(null);

        private final String jsonValue;

        private Kind(String jsonValue) {
            this.jsonValue = jsonValue;
        }

        @Override
        public String jsonValue() {
            return this.jsonValue;
        }
    }
}

