/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml.evaluate_data_frame;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class ConfusionMatrixPrediction
implements JsonpSerializable {
    private final String predictedClass;
    private final int count;
    public static final JsonpDeserializer<ConfusionMatrixPrediction> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ConfusionMatrixPrediction::setupConfusionMatrixPredictionDeserializer);

    private ConfusionMatrixPrediction(Builder builder) {
        this.predictedClass = ApiTypeHelper.requireNonNull(builder.predictedClass, this, "predictedClass");
        this.count = ApiTypeHelper.requireNonNull(builder.count, (Object)this, "count", 0);
    }

    public static ConfusionMatrixPrediction of(Function<Builder, ObjectBuilder<ConfusionMatrixPrediction>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String predictedClass() {
        return this.predictedClass;
    }

    public final int count() {
        return this.count;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("predicted_class");
        generator.write(this.predictedClass);
        generator.writeKey("count");
        generator.write(this.count);
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupConfusionMatrixPredictionDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::predictedClass, JsonpDeserializer.stringDeserializer(), "predicted_class");
        op.add(Builder::count, JsonpDeserializer.integerDeserializer(), "count");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<ConfusionMatrixPrediction> {
        private String predictedClass;
        private Integer count;

        public final Builder predictedClass(String value) {
            this.predictedClass = value;
            return this;
        }

        public final Builder count(int value) {
            this.count = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public ConfusionMatrixPrediction build() {
            this._checkSingleUse();
            return new ConfusionMatrixPrediction(this);
        }
    }
}

