/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types;

import co.elastic.clients.elasticsearch._types.Time;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class RefreshStats
implements JsonpSerializable {
    private final long externalTotal;
    private final long externalTotalTimeInMillis;
    private final long listeners;
    private final long total;
    @Nullable
    private final Time totalTime;
    private final long totalTimeInMillis;
    public static final JsonpDeserializer<RefreshStats> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, RefreshStats::setupRefreshStatsDeserializer);

    private RefreshStats(Builder builder) {
        this.externalTotal = ApiTypeHelper.requireNonNull(builder.externalTotal, (Object)this, "externalTotal", 0L);
        this.externalTotalTimeInMillis = ApiTypeHelper.requireNonNull(builder.externalTotalTimeInMillis, (Object)this, "externalTotalTimeInMillis", 0L);
        this.listeners = ApiTypeHelper.requireNonNull(builder.listeners, (Object)this, "listeners", 0L);
        this.total = ApiTypeHelper.requireNonNull(builder.total, (Object)this, "total", 0L);
        this.totalTime = builder.totalTime;
        this.totalTimeInMillis = ApiTypeHelper.requireNonNull(builder.totalTimeInMillis, (Object)this, "totalTimeInMillis", 0L);
    }

    public static RefreshStats of(Function<Builder, ObjectBuilder<RefreshStats>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final long externalTotal() {
        return this.externalTotal;
    }

    public final long externalTotalTimeInMillis() {
        return this.externalTotalTimeInMillis;
    }

    public final long listeners() {
        return this.listeners;
    }

    public final long total() {
        return this.total;
    }

    @Nullable
    public final Time totalTime() {
        return this.totalTime;
    }

    public final long totalTimeInMillis() {
        return this.totalTimeInMillis;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("external_total");
        generator.write(this.externalTotal);
        generator.writeKey("external_total_time_in_millis");
        generator.write(this.externalTotalTimeInMillis);
        generator.writeKey("listeners");
        generator.write(this.listeners);
        generator.writeKey("total");
        generator.write(this.total);
        if (this.totalTime != null) {
            generator.writeKey("total_time");
            this.totalTime.serialize(generator, mapper);
        }
        generator.writeKey("total_time_in_millis");
        generator.write(this.totalTimeInMillis);
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupRefreshStatsDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::externalTotal, JsonpDeserializer.longDeserializer(), "external_total");
        op.add(Builder::externalTotalTimeInMillis, JsonpDeserializer.longDeserializer(), "external_total_time_in_millis");
        op.add(Builder::listeners, JsonpDeserializer.longDeserializer(), "listeners");
        op.add(Builder::total, JsonpDeserializer.longDeserializer(), "total");
        op.add(Builder::totalTime, Time._DESERIALIZER, "total_time");
        op.add(Builder::totalTimeInMillis, JsonpDeserializer.longDeserializer(), "total_time_in_millis");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<RefreshStats> {
        private Long externalTotal;
        private Long externalTotalTimeInMillis;
        private Long listeners;
        private Long total;
        @Nullable
        private Time totalTime;
        private Long totalTimeInMillis;

        public final Builder externalTotal(long value) {
            this.externalTotal = value;
            return this;
        }

        public final Builder externalTotalTimeInMillis(long value) {
            this.externalTotalTimeInMillis = value;
            return this;
        }

        public final Builder listeners(long value) {
            this.listeners = value;
            return this;
        }

        public final Builder total(long value) {
            this.total = value;
            return this;
        }

        public final Builder totalTime(@Nullable Time value) {
            this.totalTime = value;
            return this;
        }

        public final Builder totalTime(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.totalTime(fn.apply(new Time.Builder()).build());
        }

        public final Builder totalTimeInMillis(long value) {
            this.totalTimeInMillis = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public RefreshStats build() {
            this._checkSingleUse();
            return new RefreshStats(this);
        }
    }
}

