/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.cat;

import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch._types.Time;
import co.elastic.clients.elasticsearch.cat.CatRequestBase;
import co.elastic.clients.elasticsearch.cat.PluginsResponse;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ObjectBuilder;
import java.util.Collections;
import java.util.HashMap;
import java.util.function.Function;
import javax.annotation.Nullable;

public class PluginsRequest
extends CatRequestBase {
    @Nullable
    private final Boolean includeBootstrap;
    @Nullable
    private final Boolean local;
    @Nullable
    private final Time masterTimeout;
    public static final Endpoint<PluginsRequest, PluginsResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<PluginsRequest, PluginsResponse>("es/cat.plugins", request -> "GET", request -> "/_cat/plugins", request -> Collections.emptyMap(), request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("format", "json");
        if (request.masterTimeout != null) {
            params.put("master_timeout", request.masterTimeout._toJsonString());
        }
        if (request.includeBootstrap != null) {
            params.put("include_bootstrap", String.valueOf(request.includeBootstrap));
        }
        if (request.local != null) {
            params.put("local", String.valueOf(request.local));
        }
        return params;
    }, SimpleEndpoint.emptyMap(), false, PluginsResponse._DESERIALIZER);

    private PluginsRequest(Builder builder) {
        this.includeBootstrap = builder.includeBootstrap;
        this.local = builder.local;
        this.masterTimeout = builder.masterTimeout;
    }

    public static PluginsRequest of(Function<Builder, ObjectBuilder<PluginsRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Boolean includeBootstrap() {
        return this.includeBootstrap;
    }

    @Nullable
    public final Boolean local() {
        return this.local;
    }

    @Nullable
    public final Time masterTimeout() {
        return this.masterTimeout;
    }

    public static class Builder
    extends CatRequestBase.AbstractBuilder<Builder>
    implements ObjectBuilder<PluginsRequest> {
        @Nullable
        private Boolean includeBootstrap;
        @Nullable
        private Boolean local;
        @Nullable
        private Time masterTimeout;

        public final Builder includeBootstrap(@Nullable Boolean value) {
            this.includeBootstrap = value;
            return this;
        }

        public final Builder local(@Nullable Boolean value) {
            this.local = value;
            return this;
        }

        public final Builder masterTimeout(@Nullable Time value) {
            this.masterTimeout = value;
            return this;
        }

        public final Builder masterTimeout(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.masterTimeout(fn.apply(new Time.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public PluginsRequest build() {
            this._checkSingleUse();
            return new PluginsRequest(this);
        }
    }
}

