/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.search_application.list;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class SearchApplicationListItem
implements JsonpSerializable {
    private final String name;
    private final List<String> indices;
    private final long updatedAtMillis;
    @Nullable
    private final String analyticsCollectionName;
    public static final JsonpDeserializer<SearchApplicationListItem> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, SearchApplicationListItem::setupSearchApplicationListItemDeserializer);

    private SearchApplicationListItem(Builder builder) {
        this.name = ApiTypeHelper.requireNonNull(builder.name, this, "name");
        this.indices = ApiTypeHelper.unmodifiableRequired(builder.indices, (Object)this, "indices");
        this.updatedAtMillis = ApiTypeHelper.requireNonNull(builder.updatedAtMillis, (Object)this, "updatedAtMillis", 0L);
        this.analyticsCollectionName = builder.analyticsCollectionName;
    }

    public static SearchApplicationListItem of(Function<Builder, ObjectBuilder<SearchApplicationListItem>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String name() {
        return this.name;
    }

    public final List<String> indices() {
        return this.indices;
    }

    public final long updatedAtMillis() {
        return this.updatedAtMillis;
    }

    @Nullable
    public final String analyticsCollectionName() {
        return this.analyticsCollectionName;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("name");
        generator.write(this.name);
        if (ApiTypeHelper.isDefined(this.indices)) {
            generator.writeKey("indices");
            generator.writeStartArray();
            for (String item0 : this.indices) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
        generator.writeKey("updated_at_millis");
        generator.write(this.updatedAtMillis);
        if (this.analyticsCollectionName != null) {
            generator.writeKey("analytics_collection_name");
            generator.write(this.analyticsCollectionName);
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupSearchApplicationListItemDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::name, JsonpDeserializer.stringDeserializer(), "name");
        op.add(Builder::indices, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "indices");
        op.add(Builder::updatedAtMillis, JsonpDeserializer.longDeserializer(), "updated_at_millis");
        op.add(Builder::analyticsCollectionName, JsonpDeserializer.stringDeserializer(), "analytics_collection_name");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<SearchApplicationListItem> {
        private String name;
        private List<String> indices;
        private Long updatedAtMillis;
        @Nullable
        private String analyticsCollectionName;

        public final Builder name(String value) {
            this.name = value;
            return this;
        }

        public final Builder indices(List<String> list) {
            this.indices = Builder._listAddAll(this.indices, list);
            return this;
        }

        public final Builder indices(String value, String ... values) {
            this.indices = Builder._listAdd(this.indices, value, values);
            return this;
        }

        public final Builder updatedAtMillis(long value) {
            this.updatedAtMillis = value;
            return this;
        }

        public final Builder analyticsCollectionName(@Nullable String value) {
            this.analyticsCollectionName = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public SearchApplicationListItem build() {
            this._checkSingleUse();
            return new SearchApplicationListItem(this);
        }
    }
}

