/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.watcher;

import co.elastic.clients.elasticsearch.watcher.QueryWatch;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;

@JsonpDeserializable
public class QueryWatchesResponse
implements JsonpSerializable {
    private final int count;
    private final List<QueryWatch> watches;
    public static final JsonpDeserializer<QueryWatchesResponse> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, QueryWatchesResponse::setupQueryWatchesResponseDeserializer);

    private QueryWatchesResponse(Builder builder) {
        this.count = ApiTypeHelper.requireNonNull(builder.count, (Object)this, "count", 0);
        this.watches = ApiTypeHelper.unmodifiableRequired(builder.watches, (Object)this, "watches");
    }

    public static QueryWatchesResponse of(Function<Builder, ObjectBuilder<QueryWatchesResponse>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final int count() {
        return this.count;
    }

    public final List<QueryWatch> watches() {
        return this.watches;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("count");
        generator.write(this.count);
        if (ApiTypeHelper.isDefined(this.watches)) {
            generator.writeKey("watches");
            generator.writeStartArray();
            for (QueryWatch item0 : this.watches) {
                item0.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupQueryWatchesResponseDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::count, JsonpDeserializer.integerDeserializer(), "count");
        op.add(Builder::watches, JsonpDeserializer.arrayDeserializer(QueryWatch._DESERIALIZER), "watches");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<QueryWatchesResponse> {
        private Integer count;
        private List<QueryWatch> watches;

        public final Builder count(int value) {
            this.count = value;
            return this;
        }

        public final Builder watches(List<QueryWatch> list) {
            this.watches = Builder._listAddAll(this.watches, list);
            return this;
        }

        public final Builder watches(QueryWatch value, QueryWatch ... values) {
            this.watches = Builder._listAdd(this.watches, value, values);
            return this;
        }

        public final Builder watches(Function<QueryWatch.Builder, ObjectBuilder<QueryWatch>> fn) {
            return this.watches(fn.apply(new QueryWatch.Builder()).build(), new QueryWatch[0]);
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public QueryWatchesResponse build() {
            this._checkSingleUse();
            return new QueryWatchesResponse(this);
        }
    }
}

