/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.snapshot.repository_analyze;

import co.elastic.clients.elasticsearch.snapshot.repository_analyze.ReadBlobDetails;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class BlobDetails
implements JsonpSerializable {
    private final String name;
    private final boolean overwritten;
    private final boolean readEarly;
    private final long readEnd;
    private final long readStart;
    private final ReadBlobDetails reads;
    private final String size;
    private final long sizeBytes;
    public static final JsonpDeserializer<BlobDetails> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, BlobDetails::setupBlobDetailsDeserializer);

    private BlobDetails(Builder builder) {
        this.name = ApiTypeHelper.requireNonNull(builder.name, this, "name");
        this.overwritten = ApiTypeHelper.requireNonNull(builder.overwritten, this, "overwritten");
        this.readEarly = ApiTypeHelper.requireNonNull(builder.readEarly, this, "readEarly");
        this.readEnd = ApiTypeHelper.requireNonNull(builder.readEnd, this, "readEnd");
        this.readStart = ApiTypeHelper.requireNonNull(builder.readStart, this, "readStart");
        this.reads = ApiTypeHelper.requireNonNull(builder.reads, this, "reads");
        this.size = ApiTypeHelper.requireNonNull(builder.size, this, "size");
        this.sizeBytes = ApiTypeHelper.requireNonNull(builder.sizeBytes, this, "sizeBytes");
    }

    public static BlobDetails of(Function<Builder, ObjectBuilder<BlobDetails>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String name() {
        return this.name;
    }

    public final boolean overwritten() {
        return this.overwritten;
    }

    public final boolean readEarly() {
        return this.readEarly;
    }

    public final long readEnd() {
        return this.readEnd;
    }

    public final long readStart() {
        return this.readStart;
    }

    public final ReadBlobDetails reads() {
        return this.reads;
    }

    public final String size() {
        return this.size;
    }

    public final long sizeBytes() {
        return this.sizeBytes;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("name");
        generator.write(this.name);
        generator.writeKey("overwritten");
        generator.write(this.overwritten);
        generator.writeKey("read_early");
        generator.write(this.readEarly);
        generator.writeKey("read_end");
        generator.write(this.readEnd);
        generator.writeKey("read_start");
        generator.write(this.readStart);
        generator.writeKey("reads");
        this.reads.serialize(generator, mapper);
        generator.writeKey("size");
        generator.write(this.size);
        generator.writeKey("size_bytes");
        generator.write(this.sizeBytes);
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupBlobDetailsDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::name, JsonpDeserializer.stringDeserializer(), "name");
        op.add(Builder::overwritten, JsonpDeserializer.booleanDeserializer(), "overwritten");
        op.add(Builder::readEarly, JsonpDeserializer.booleanDeserializer(), "read_early");
        op.add(Builder::readEnd, JsonpDeserializer.longDeserializer(), "read_end");
        op.add(Builder::readStart, JsonpDeserializer.longDeserializer(), "read_start");
        op.add(Builder::reads, ReadBlobDetails._DESERIALIZER, "reads");
        op.add(Builder::size, JsonpDeserializer.stringDeserializer(), "size");
        op.add(Builder::sizeBytes, JsonpDeserializer.longDeserializer(), "size_bytes");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<BlobDetails> {
        private String name;
        private Boolean overwritten;
        private Boolean readEarly;
        private Long readEnd;
        private Long readStart;
        private ReadBlobDetails reads;
        private String size;
        private Long sizeBytes;

        public final Builder name(String value) {
            this.name = value;
            return this;
        }

        public final Builder overwritten(boolean value) {
            this.overwritten = value;
            return this;
        }

        public final Builder readEarly(boolean value) {
            this.readEarly = value;
            return this;
        }

        public final Builder readEnd(long value) {
            this.readEnd = value;
            return this;
        }

        public final Builder readStart(long value) {
            this.readStart = value;
            return this;
        }

        public final Builder reads(ReadBlobDetails value) {
            this.reads = value;
            return this;
        }

        public final Builder reads(Function<ReadBlobDetails.Builder, ObjectBuilder<ReadBlobDetails>> fn) {
            return this.reads(fn.apply(new ReadBlobDetails.Builder()).build());
        }

        public final Builder size(String value) {
            this.size = value;
            return this;
        }

        public final Builder sizeBytes(long value) {
            this.sizeBytes = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public BlobDetails build() {
            this._checkSingleUse();
            return new BlobDetails(this);
        }
    }
}

