/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.elasticsearch.ml.InferenceConfigCreate;
import co.elastic.clients.elasticsearch.ml.InferenceConfigCreateVariant;
import co.elastic.clients.elasticsearch.ml.QueryFeatureExtractor;
import co.elastic.clients.json.JsonData;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class LearningToRankConfig
implements InferenceConfigCreateVariant,
JsonpSerializable {
    private final Map<String, JsonData> defaultParams;
    private final List<Map<String, QueryFeatureExtractor>> featureExtractors;
    private final int numTopFeatureImportanceValues;
    public static final JsonpDeserializer<LearningToRankConfig> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, LearningToRankConfig::setupLearningToRankConfigDeserializer);

    private LearningToRankConfig(Builder builder) {
        this.defaultParams = ApiTypeHelper.unmodifiable(builder.defaultParams);
        this.featureExtractors = ApiTypeHelper.unmodifiable(builder.featureExtractors);
        this.numTopFeatureImportanceValues = ApiTypeHelper.requireNonNull(builder.numTopFeatureImportanceValues, this, "numTopFeatureImportanceValues");
    }

    public static LearningToRankConfig of(Function<Builder, ObjectBuilder<LearningToRankConfig>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public InferenceConfigCreate.Kind _inferenceConfigCreateKind() {
        return InferenceConfigCreate.Kind.LearningToRank;
    }

    public final Map<String, JsonData> defaultParams() {
        return this.defaultParams;
    }

    public final List<Map<String, QueryFeatureExtractor>> featureExtractors() {
        return this.featureExtractors;
    }

    public final int numTopFeatureImportanceValues() {
        return this.numTopFeatureImportanceValues;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (ApiTypeHelper.isDefined(this.defaultParams)) {
            generator.writeKey("default_params");
            generator.writeStartObject();
            for (Map.Entry entry : this.defaultParams.entrySet()) {
                generator.writeKey((String)entry.getKey());
                ((JsonData)entry.getValue()).serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.featureExtractors)) {
            generator.writeKey("feature_extractors");
            generator.writeStartArray();
            for (Map map : this.featureExtractors) {
                generator.writeStartObject();
                if (map != null) {
                    for (Map.Entry item1 : map.entrySet()) {
                        generator.writeKey((String)item1.getKey());
                        ((QueryFeatureExtractor)item1.getValue()).serialize(generator, mapper);
                    }
                }
                generator.writeEnd();
            }
            generator.writeEnd();
        }
        generator.writeKey("num_top_feature_importance_values");
        generator.write(this.numTopFeatureImportanceValues);
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupLearningToRankConfigDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::defaultParams, JsonpDeserializer.stringMapDeserializer(JsonData._DESERIALIZER), "default_params");
        op.add(Builder::featureExtractors, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringMapDeserializer(QueryFeatureExtractor._DESERIALIZER)), "feature_extractors");
        op.add(Builder::numTopFeatureImportanceValues, JsonpDeserializer.integerDeserializer(), "num_top_feature_importance_values");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<LearningToRankConfig> {
        @Nullable
        private Map<String, JsonData> defaultParams;
        @Nullable
        private List<Map<String, QueryFeatureExtractor>> featureExtractors;
        private Integer numTopFeatureImportanceValues;

        public final Builder defaultParams(Map<String, JsonData> map) {
            this.defaultParams = Builder._mapPutAll(this.defaultParams, map);
            return this;
        }

        public final Builder defaultParams(String key, JsonData value) {
            this.defaultParams = Builder._mapPut(this.defaultParams, key, value);
            return this;
        }

        public final Builder featureExtractors(List<Map<String, QueryFeatureExtractor>> list) {
            this.featureExtractors = Builder._listAddAll(this.featureExtractors, list);
            return this;
        }

        public final Builder featureExtractors(Map<String, QueryFeatureExtractor> value, Map<String, QueryFeatureExtractor> ... values) {
            this.featureExtractors = Builder._listAdd(this.featureExtractors, value, values);
            return this;
        }

        public final Builder numTopFeatureImportanceValues(int value) {
            this.numTopFeatureImportanceValues = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public LearningToRankConfig build() {
            this._checkSingleUse();
            return new LearningToRankConfig(this);
        }
    }
}

