/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.security;

import co.elastic.clients.elasticsearch._types.ScriptLanguage;
import co.elastic.clients.elasticsearch.security.RoleTemplateInlineQuery;
import co.elastic.clients.json.JsonData;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class RoleTemplateScript
implements JsonpSerializable {
    @Nullable
    private final RoleTemplateInlineQuery source;
    @Nullable
    private final String id;
    private final Map<String, JsonData> params;
    @Nullable
    private final String lang;
    private final Map<String, String> options;
    public static final JsonpDeserializer<RoleTemplateScript> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, RoleTemplateScript::setupRoleTemplateScriptDeserializer);

    private RoleTemplateScript(Builder builder) {
        this.source = builder.source;
        this.id = builder.id;
        this.params = ApiTypeHelper.unmodifiable(builder.params);
        this.lang = builder.lang;
        this.options = ApiTypeHelper.unmodifiable(builder.options);
    }

    public static RoleTemplateScript of(Function<Builder, ObjectBuilder<RoleTemplateScript>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final RoleTemplateInlineQuery source() {
        return this.source;
    }

    @Nullable
    public final String id() {
        return this.id;
    }

    public final Map<String, JsonData> params() {
        return this.params;
    }

    @Nullable
    public final String lang() {
        return this.lang;
    }

    public final Map<String, String> options() {
        return this.options;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.source != null) {
            generator.writeKey("source");
            this.source.serialize(generator, mapper);
        }
        if (this.id != null) {
            generator.writeKey("id");
            generator.write(this.id);
        }
        if (ApiTypeHelper.isDefined(this.params)) {
            generator.writeKey("params");
            generator.writeStartObject();
            for (Map.Entry<String, JsonData> entry : this.params.entrySet()) {
                generator.writeKey(entry.getKey());
                entry.getValue().serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.lang != null) {
            generator.writeKey("lang");
            generator.write(this.lang);
        }
        if (ApiTypeHelper.isDefined(this.options)) {
            generator.writeKey("options");
            generator.writeStartObject();
            for (Map.Entry<String, Object> entry : this.options.entrySet()) {
                generator.writeKey(entry.getKey());
                generator.write((String)entry.getValue());
            }
            generator.writeEnd();
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupRoleTemplateScriptDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::source, RoleTemplateInlineQuery._DESERIALIZER, "source");
        op.add(Builder::id, JsonpDeserializer.stringDeserializer(), "id");
        op.add(Builder::params, JsonpDeserializer.stringMapDeserializer(JsonData._DESERIALIZER), "params");
        op.add(Builder::lang, JsonpDeserializer.stringDeserializer(), "lang");
        op.add(Builder::options, JsonpDeserializer.stringMapDeserializer(JsonpDeserializer.stringDeserializer()), "options");
        op.shortcutProperty("source");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<RoleTemplateScript> {
        @Nullable
        private RoleTemplateInlineQuery source;
        @Nullable
        private String id;
        @Nullable
        private Map<String, JsonData> params;
        @Nullable
        private String lang;
        @Nullable
        private Map<String, String> options;

        public final Builder source(@Nullable RoleTemplateInlineQuery value) {
            this.source = value;
            return this;
        }

        public final Builder source(Function<RoleTemplateInlineQuery.Builder, ObjectBuilder<RoleTemplateInlineQuery>> fn) {
            return this.source(fn.apply(new RoleTemplateInlineQuery.Builder()).build());
        }

        public final Builder id(@Nullable String value) {
            this.id = value;
            return this;
        }

        public final Builder params(Map<String, JsonData> map) {
            this.params = Builder._mapPutAll(this.params, map);
            return this;
        }

        public final Builder params(String key, JsonData value) {
            this.params = Builder._mapPut(this.params, key, value);
            return this;
        }

        public final Builder lang(@Nullable String value) {
            this.lang = value;
            return this;
        }

        public final Builder lang(@Nullable ScriptLanguage value) {
            this.lang = value == null ? null : value.jsonValue();
            return this;
        }

        public final Builder options(Map<String, String> map) {
            this.options = Builder._mapPutAll(this.options, map);
            return this;
        }

        public final Builder options(String key, String value) {
            this.options = Builder._mapPut(this.options, key, value);
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public RoleTemplateScript build() {
            this._checkSingleUse();
            return new RoleTemplateScript(this);
        }
    }
}

