/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ingest;

import co.elastic.clients.elasticsearch.ingest.Maxmind;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class DatabaseConfiguration
implements JsonpSerializable {
    private final String name;
    private final Maxmind maxmind;
    public static final JsonpDeserializer<DatabaseConfiguration> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, DatabaseConfiguration::setupDatabaseConfigurationDeserializer);

    private DatabaseConfiguration(Builder builder) {
        this.name = ApiTypeHelper.requireNonNull(builder.name, this, "name");
        this.maxmind = ApiTypeHelper.requireNonNull(builder.maxmind, this, "maxmind");
    }

    public static DatabaseConfiguration of(Function<Builder, ObjectBuilder<DatabaseConfiguration>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String name() {
        return this.name;
    }

    public final Maxmind maxmind() {
        return this.maxmind;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("name");
        generator.write(this.name);
        generator.writeKey("maxmind");
        this.maxmind.serialize(generator, mapper);
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupDatabaseConfigurationDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::name, JsonpDeserializer.stringDeserializer(), "name");
        op.add(Builder::maxmind, Maxmind._DESERIALIZER, "maxmind");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<DatabaseConfiguration> {
        private String name;
        private Maxmind maxmind;

        public final Builder name(String value) {
            this.name = value;
            return this;
        }

        public final Builder maxmind(Maxmind value) {
            this.maxmind = value;
            return this;
        }

        public final Builder maxmind(Function<Maxmind.Builder, ObjectBuilder<Maxmind>> fn) {
            return this.maxmind(fn.apply(new Maxmind.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public DatabaseConfiguration build() {
            this._checkSingleUse();
            return new DatabaseConfiguration(this);
        }
    }
}

