/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.security;

import co.elastic.clients.elasticsearch.security.query_role.QueryRole;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;

@JsonpDeserializable
public class QueryRoleResponse
implements JsonpSerializable {
    private final int total;
    private final int count;
    private final List<QueryRole> roles;
    public static final JsonpDeserializer<QueryRoleResponse> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, QueryRoleResponse::setupQueryRoleResponseDeserializer);

    private QueryRoleResponse(Builder builder) {
        this.total = ApiTypeHelper.requireNonNull(builder.total, this, "total");
        this.count = ApiTypeHelper.requireNonNull(builder.count, this, "count");
        this.roles = ApiTypeHelper.unmodifiableRequired(builder.roles, (Object)this, "roles");
    }

    public static QueryRoleResponse of(Function<Builder, ObjectBuilder<QueryRoleResponse>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final int total() {
        return this.total;
    }

    public final int count() {
        return this.count;
    }

    public final List<QueryRole> roles() {
        return this.roles;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("total");
        generator.write(this.total);
        generator.writeKey("count");
        generator.write(this.count);
        if (ApiTypeHelper.isDefined(this.roles)) {
            generator.writeKey("roles");
            generator.writeStartArray();
            for (QueryRole item0 : this.roles) {
                item0.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupQueryRoleResponseDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::total, JsonpDeserializer.integerDeserializer(), "total");
        op.add(Builder::count, JsonpDeserializer.integerDeserializer(), "count");
        op.add(Builder::roles, JsonpDeserializer.arrayDeserializer(QueryRole._DESERIALIZER), "roles");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<QueryRoleResponse> {
        private Integer total;
        private Integer count;
        private List<QueryRole> roles;

        public final Builder total(int value) {
            this.total = value;
            return this;
        }

        public final Builder count(int value) {
            this.count = value;
            return this;
        }

        public final Builder roles(List<QueryRole> list) {
            this.roles = Builder._listAddAll(this.roles, list);
            return this;
        }

        public final Builder roles(QueryRole value, QueryRole ... values) {
            this.roles = Builder._listAdd(this.roles, value, values);
            return this;
        }

        public final Builder roles(Function<QueryRole.Builder, ObjectBuilder<QueryRole>> fn) {
            return this.roles(fn.apply(new QueryRole.Builder()).build(), new QueryRole[0]);
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public QueryRoleResponse build() {
            this._checkSingleUse();
            return new QueryRoleResponse(this);
        }
    }
}

