/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ingest.get_geoip_database;

import co.elastic.clients.elasticsearch.ingest.get_geoip_database.DatabaseConfiguration;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class DatabaseConfigurationMetadata
implements JsonpSerializable {
    private final String id;
    private final long version;
    private final long modifiedDateMillis;
    private final DatabaseConfiguration database;
    public static final JsonpDeserializer<DatabaseConfigurationMetadata> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, DatabaseConfigurationMetadata::setupDatabaseConfigurationMetadataDeserializer);

    private DatabaseConfigurationMetadata(Builder builder) {
        this.id = ApiTypeHelper.requireNonNull(builder.id, this, "id");
        this.version = ApiTypeHelper.requireNonNull(builder.version, this, "version");
        this.modifiedDateMillis = ApiTypeHelper.requireNonNull(builder.modifiedDateMillis, this, "modifiedDateMillis");
        this.database = ApiTypeHelper.requireNonNull(builder.database, this, "database");
    }

    public static DatabaseConfigurationMetadata of(Function<Builder, ObjectBuilder<DatabaseConfigurationMetadata>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String id() {
        return this.id;
    }

    public final long version() {
        return this.version;
    }

    public final long modifiedDateMillis() {
        return this.modifiedDateMillis;
    }

    public final DatabaseConfiguration database() {
        return this.database;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("id");
        generator.write(this.id);
        generator.writeKey("version");
        generator.write(this.version);
        generator.writeKey("modified_date_millis");
        generator.write(this.modifiedDateMillis);
        generator.writeKey("database");
        this.database.serialize(generator, mapper);
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupDatabaseConfigurationMetadataDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::id, JsonpDeserializer.stringDeserializer(), "id");
        op.add(Builder::version, JsonpDeserializer.longDeserializer(), "version");
        op.add(Builder::modifiedDateMillis, JsonpDeserializer.longDeserializer(), "modified_date_millis");
        op.add(Builder::database, DatabaseConfiguration._DESERIALIZER, "database");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<DatabaseConfigurationMetadata> {
        private String id;
        private Long version;
        private Long modifiedDateMillis;
        private DatabaseConfiguration database;

        public final Builder id(String value) {
            this.id = value;
            return this;
        }

        public final Builder version(long value) {
            this.version = value;
            return this;
        }

        public final Builder modifiedDateMillis(long value) {
            this.modifiedDateMillis = value;
            return this;
        }

        public final Builder database(DatabaseConfiguration value) {
            this.database = value;
            return this;
        }

        public final Builder database(Function<DatabaseConfiguration.Builder, ObjectBuilder<DatabaseConfiguration>> fn) {
            return this.database(fn.apply(new DatabaseConfiguration.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public DatabaseConfigurationMetadata build() {
            this._checkSingleUse();
            return new DatabaseConfigurationMetadata(this);
        }
    }
}

