/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package co.elastic.clients.json;

import jakarta.json.stream.JsonParser;
import jakarta.json.stream.JsonParser.Event;
import jakarta.json.stream.JsonParsingException;

import java.util.EnumSet;

public class UnexpectedJsonEventException extends JsonParsingException {
    public UnexpectedJsonEventException(JsonParser parser, Event event) {
        super("Unexpected JSON event '" + event + "'", parser.getLocation());
    }

    public UnexpectedJsonEventException(JsonParser parser, Event event, Event expected) {
        super("Unexpected JSON event '" + event + "' instead of '" + expected + "'", parser.getLocation());
    }

    public UnexpectedJsonEventException(JsonParser parser, Event event, EnumSet<Event> expected) {
        super("Unexpected JSON event '" + event + "' instead of '" + expected + "'", parser.getLocation());
    }
}
