/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.inference;

import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch.inference.DeleteModelResponse;
import co.elastic.clients.elasticsearch.inference.TaskType;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import java.util.Collections;
import java.util.HashMap;
import java.util.function.Function;

public class DeleteModelRequest
extends RequestBase {
    private final String modelId;
    private final TaskType taskType;
    public static final Endpoint<DeleteModelRequest, DeleteModelResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<DeleteModelRequest, DeleteModelResponse>("es/inference.delete_model", request -> "DELETE", request -> {
        boolean _modelId = true;
        int _taskType = 2;
        int propsSet = 0;
        propsSet |= 1;
        if ((propsSet |= 2) == 3) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_inference");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.taskType.jsonValue(), buf);
            buf.append("/");
            SimpleEndpoint.pathEncode(request.modelId, buf);
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        boolean _modelId = true;
        int _taskType = 2;
        int propsSet = 0;
        propsSet |= 1;
        if ((propsSet |= 2) == 3) {
            params.put("taskType", request.taskType.jsonValue());
            params.put("modelId", request.modelId);
        }
        return params;
    }, request -> Collections.emptyMap(), SimpleEndpoint.emptyMap(), false, DeleteModelResponse._DESERIALIZER);

    private DeleteModelRequest(Builder builder) {
        this.modelId = ApiTypeHelper.requireNonNull(builder.modelId, this, "modelId");
        this.taskType = ApiTypeHelper.requireNonNull(builder.taskType, this, "taskType");
    }

    public static DeleteModelRequest of(Function<Builder, ObjectBuilder<DeleteModelRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String modelId() {
        return this.modelId;
    }

    public final TaskType taskType() {
        return this.taskType;
    }

    public static class Builder
    extends RequestBase.AbstractBuilder<Builder>
    implements ObjectBuilder<DeleteModelRequest> {
        private String modelId;
        private TaskType taskType;

        public final Builder modelId(String value) {
            this.modelId = value;
            return this;
        }

        public final Builder taskType(TaskType value) {
            this.taskType = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public DeleteModelRequest build() {
            this._checkSingleUse();
            return new DeleteModelRequest(this);
        }
    }
}

