/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.mapping;

import co.elastic.clients.elasticsearch._types.mapping.MatchType;
import co.elastic.clients.elasticsearch._types.mapping.Property;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class DynamicTemplate
implements JsonpSerializable {
    @Nullable
    private final Property mapping;
    @Nullable
    private final String match;
    @Nullable
    private final String matchMappingType;
    @Nullable
    private final MatchType matchPattern;
    @Nullable
    private final String pathMatch;
    @Nullable
    private final String pathUnmatch;
    @Nullable
    private final String unmatch;
    public static final JsonpDeserializer<DynamicTemplate> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, DynamicTemplate::setupDynamicTemplateDeserializer);

    private DynamicTemplate(Builder builder) {
        this.mapping = builder.mapping;
        this.match = builder.match;
        this.matchMappingType = builder.matchMappingType;
        this.matchPattern = builder.matchPattern;
        this.pathMatch = builder.pathMatch;
        this.pathUnmatch = builder.pathUnmatch;
        this.unmatch = builder.unmatch;
    }

    public static DynamicTemplate of(Function<Builder, ObjectBuilder<DynamicTemplate>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Property mapping() {
        return this.mapping;
    }

    @Nullable
    public final String match() {
        return this.match;
    }

    @Nullable
    public final String matchMappingType() {
        return this.matchMappingType;
    }

    @Nullable
    public final MatchType matchPattern() {
        return this.matchPattern;
    }

    @Nullable
    public final String pathMatch() {
        return this.pathMatch;
    }

    @Nullable
    public final String pathUnmatch() {
        return this.pathUnmatch;
    }

    @Nullable
    public final String unmatch() {
        return this.unmatch;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.mapping != null) {
            generator.writeKey("mapping");
            this.mapping.serialize(generator, mapper);
        }
        if (this.match != null) {
            generator.writeKey("match");
            generator.write(this.match);
        }
        if (this.matchMappingType != null) {
            generator.writeKey("match_mapping_type");
            generator.write(this.matchMappingType);
        }
        if (this.matchPattern != null) {
            generator.writeKey("match_pattern");
            this.matchPattern.serialize(generator, mapper);
        }
        if (this.pathMatch != null) {
            generator.writeKey("path_match");
            generator.write(this.pathMatch);
        }
        if (this.pathUnmatch != null) {
            generator.writeKey("path_unmatch");
            generator.write(this.pathUnmatch);
        }
        if (this.unmatch != null) {
            generator.writeKey("unmatch");
            generator.write(this.unmatch);
        }
    }

    protected static void setupDynamicTemplateDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::mapping, Property._DESERIALIZER, "mapping");
        op.add(Builder::match, JsonpDeserializer.stringDeserializer(), "match");
        op.add(Builder::matchMappingType, JsonpDeserializer.stringDeserializer(), "match_mapping_type");
        op.add(Builder::matchPattern, MatchType._DESERIALIZER, "match_pattern");
        op.add(Builder::pathMatch, JsonpDeserializer.stringDeserializer(), "path_match");
        op.add(Builder::pathUnmatch, JsonpDeserializer.stringDeserializer(), "path_unmatch");
        op.add(Builder::unmatch, JsonpDeserializer.stringDeserializer(), "unmatch");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<DynamicTemplate> {
        @Nullable
        private Property mapping;
        @Nullable
        private String match;
        @Nullable
        private String matchMappingType;
        @Nullable
        private MatchType matchPattern;
        @Nullable
        private String pathMatch;
        @Nullable
        private String pathUnmatch;
        @Nullable
        private String unmatch;

        public final Builder mapping(@Nullable Property value) {
            this.mapping = value;
            return this;
        }

        public final Builder mapping(Function<Property.Builder, ObjectBuilder<Property>> fn) {
            return this.mapping(fn.apply(new Property.Builder()).build());
        }

        public final Builder match(@Nullable String value) {
            this.match = value;
            return this;
        }

        public final Builder matchMappingType(@Nullable String value) {
            this.matchMappingType = value;
            return this;
        }

        public final Builder matchPattern(@Nullable MatchType value) {
            this.matchPattern = value;
            return this;
        }

        public final Builder pathMatch(@Nullable String value) {
            this.pathMatch = value;
            return this;
        }

        public final Builder pathUnmatch(@Nullable String value) {
            this.pathUnmatch = value;
            return this;
        }

        public final Builder unmatch(@Nullable String value) {
            this.unmatch = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public DynamicTemplate build() {
            this._checkSingleUse();
            return new DynamicTemplate(this);
        }
    }
}

