/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.security.get_service_credentials;

import co.elastic.clients.elasticsearch._types.NodeStatistics;
import co.elastic.clients.elasticsearch.security.get_service_credentials.NodesCredentialsFileToken;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.ObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.Map;
import java.util.function.Function;

@JsonpDeserializable
public class NodesCredentials
implements JsonpSerializable {
    private final NodeStatistics nodes;
    private final Map<String, NodesCredentialsFileToken> fileTokens;
    public static final JsonpDeserializer<NodesCredentials> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, NodesCredentials::setupNodesCredentialsDeserializer);

    private NodesCredentials(Builder builder) {
        this.nodes = ApiTypeHelper.requireNonNull(builder.nodes, this, "nodes");
        this.fileTokens = ApiTypeHelper.unmodifiableRequired(builder.fileTokens, (Object)this, "fileTokens");
    }

    public static NodesCredentials of(Function<Builder, ObjectBuilder<NodesCredentials>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final NodeStatistics nodes() {
        return this.nodes;
    }

    public final Map<String, NodesCredentialsFileToken> fileTokens() {
        return this.fileTokens;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("_nodes");
        this.nodes.serialize(generator, mapper);
        if (ApiTypeHelper.isDefined(this.fileTokens)) {
            generator.writeKey("file_tokens");
            generator.writeStartObject();
            for (Map.Entry<String, NodesCredentialsFileToken> item0 : this.fileTokens.entrySet()) {
                generator.writeKey(item0.getKey());
                item0.getValue().serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    protected static void setupNodesCredentialsDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::nodes, NodeStatistics._DESERIALIZER, "_nodes");
        op.add(Builder::fileTokens, JsonpDeserializer.stringMapDeserializer(NodesCredentialsFileToken._DESERIALIZER), "file_tokens");
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<NodesCredentials> {
        private NodeStatistics nodes;
        private Map<String, NodesCredentialsFileToken> fileTokens;

        public final Builder nodes(NodeStatistics value) {
            this.nodes = value;
            return this;
        }

        public final Builder nodes(Function<NodeStatistics.Builder, ObjectBuilder<NodeStatistics>> fn) {
            return this.nodes(fn.apply(new NodeStatistics.Builder()).build());
        }

        public final Builder fileTokens(Map<String, NodesCredentialsFileToken> map) {
            this.fileTokens = Builder._mapPutAll(this.fileTokens, map);
            return this;
        }

        public final Builder fileTokens(String key, NodesCredentialsFileToken value) {
            this.fileTokens = Builder._mapPut(this.fileTokens, key, value);
            return this;
        }

        public final Builder fileTokens(String key, Function<NodesCredentialsFileToken.Builder, ObjectBuilder<NodesCredentialsFileToken>> fn) {
            return this.fileTokens(key, fn.apply(new NodesCredentialsFileToken.Builder()).build());
        }

        @Override
        public NodesCredentials build() {
            this._checkSingleUse();
            return new NodesCredentials(this);
        }
    }
}

