/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.nodes;

import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch._types.Time;
import co.elastic.clients.elasticsearch.nodes.ReloadSecureSettingsResponse;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.ObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

@JsonpDeserializable
public class ReloadSecureSettingsRequest
extends RequestBase
implements JsonpSerializable {
    private final List<String> nodeId;
    @Nullable
    private final String secureSettingsPassword;
    @Nullable
    private final Time timeout;
    public static final JsonpDeserializer<ReloadSecureSettingsRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ReloadSecureSettingsRequest::setupReloadSecureSettingsRequestDeserializer);
    public static final Endpoint<ReloadSecureSettingsRequest, ReloadSecureSettingsResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<ReloadSecureSettingsRequest, ReloadSecureSettingsResponse>("es/nodes.reload_secure_settings", request -> "POST", request -> {
        boolean _nodeId = true;
        boolean propsSet = false;
        if (ApiTypeHelper.isDefined(request.nodeId())) {
            propsSet |= true;
        }
        if (!propsSet) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_nodes");
            buf.append("/reload_secure_settings");
            return buf.toString();
        }
        if (propsSet) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_nodes");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.nodeId.stream().map(v -> v).collect(Collectors.joining(",")), buf);
            buf.append("/reload_secure_settings");
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.timeout != null) {
            params.put("timeout", request.timeout._toJsonString());
        }
        return params;
    }, SimpleEndpoint.emptyMap(), true, ReloadSecureSettingsResponse._DESERIALIZER);

    private ReloadSecureSettingsRequest(Builder builder) {
        this.nodeId = ApiTypeHelper.unmodifiable(builder.nodeId);
        this.secureSettingsPassword = builder.secureSettingsPassword;
        this.timeout = builder.timeout;
    }

    public static ReloadSecureSettingsRequest of(Function<Builder, ObjectBuilder<ReloadSecureSettingsRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final List<String> nodeId() {
        return this.nodeId;
    }

    @Nullable
    public final String secureSettingsPassword() {
        return this.secureSettingsPassword;
    }

    @Nullable
    public final Time timeout() {
        return this.timeout;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.secureSettingsPassword != null) {
            generator.writeKey("secure_settings_password");
            generator.write(this.secureSettingsPassword);
        }
    }

    protected static void setupReloadSecureSettingsRequestDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::secureSettingsPassword, JsonpDeserializer.stringDeserializer(), "secure_settings_password");
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<ReloadSecureSettingsRequest> {
        @Nullable
        private List<String> nodeId;
        @Nullable
        private String secureSettingsPassword;
        @Nullable
        private Time timeout;

        public final Builder nodeId(List<String> list) {
            this.nodeId = Builder._listAddAll(this.nodeId, list);
            return this;
        }

        public final Builder nodeId(String value, String ... values) {
            this.nodeId = Builder._listAdd(this.nodeId, value, values);
            return this;
        }

        public final Builder secureSettingsPassword(@Nullable String value) {
            this.secureSettingsPassword = value;
            return this;
        }

        public final Builder timeout(@Nullable Time value) {
            this.timeout = value;
            return this;
        }

        public final Builder timeout(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.timeout(fn.apply(new Time.Builder()).build());
        }

        @Override
        public ReloadSecureSettingsRequest build() {
            this._checkSingleUse();
            return new ReloadSecureSettingsRequest(this);
        }
    }
}

