/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml.put_trained_model;

import co.elastic.clients.elasticsearch.ml.put_trained_model.Preprocessor;
import co.elastic.clients.elasticsearch.ml.put_trained_model.PreprocessorVariant;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.ObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.Map;
import java.util.function.Function;

@JsonpDeserializable
public class FrequencyEncodingPreprocessor
implements PreprocessorVariant,
JsonpSerializable {
    private final String field;
    private final String featureName;
    private final Map<String, Double> frequencyMap;
    public static final JsonpDeserializer<FrequencyEncodingPreprocessor> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, FrequencyEncodingPreprocessor::setupFrequencyEncodingPreprocessorDeserializer);

    private FrequencyEncodingPreprocessor(Builder builder) {
        this.field = ApiTypeHelper.requireNonNull(builder.field, this, "field");
        this.featureName = ApiTypeHelper.requireNonNull(builder.featureName, this, "featureName");
        this.frequencyMap = ApiTypeHelper.unmodifiableRequired(builder.frequencyMap, (Object)this, "frequencyMap");
    }

    public static FrequencyEncodingPreprocessor of(Function<Builder, ObjectBuilder<FrequencyEncodingPreprocessor>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Preprocessor.Kind _preprocessorKind() {
        return Preprocessor.Kind.FrequencyEncoding;
    }

    public final String field() {
        return this.field;
    }

    public final String featureName() {
        return this.featureName;
    }

    public final Map<String, Double> frequencyMap() {
        return this.frequencyMap;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("field");
        generator.write(this.field);
        generator.writeKey("feature_name");
        generator.write(this.featureName);
        if (ApiTypeHelper.isDefined(this.frequencyMap)) {
            generator.writeKey("frequency_map");
            generator.writeStartObject();
            for (Map.Entry<String, Double> item0 : this.frequencyMap.entrySet()) {
                generator.writeKey(item0.getKey());
                generator.write(item0.getValue().doubleValue());
            }
            generator.writeEnd();
        }
    }

    protected static void setupFrequencyEncodingPreprocessorDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::field, JsonpDeserializer.stringDeserializer(), "field");
        op.add(Builder::featureName, JsonpDeserializer.stringDeserializer(), "feature_name");
        op.add(Builder::frequencyMap, JsonpDeserializer.stringMapDeserializer(JsonpDeserializer.doubleDeserializer()), "frequency_map");
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<FrequencyEncodingPreprocessor> {
        private String field;
        private String featureName;
        private Map<String, Double> frequencyMap;

        public final Builder field(String value) {
            this.field = value;
            return this;
        }

        public final Builder featureName(String value) {
            this.featureName = value;
            return this;
        }

        public final Builder frequencyMap(Map<String, Double> map) {
            this.frequencyMap = Builder._mapPutAll(this.frequencyMap, map);
            return this;
        }

        public final Builder frequencyMap(String key, Double value) {
            this.frequencyMap = Builder._mapPut(this.frequencyMap, key, value);
            return this;
        }

        @Override
        public FrequencyEncodingPreprocessor build() {
            this._checkSingleUse();
            return new FrequencyEncodingPreprocessor(this);
        }
    }
}

