/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.elasticsearch._types.mapping.RuntimeField;
import co.elastic.clients.elasticsearch._types.query_dsl.Query;
import co.elastic.clients.elasticsearch.ml.DataframeAnalysisAnalyzedFields;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.ObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class DataframeAnalyticsSource
implements JsonpSerializable {
    private final List<String> index;
    @Nullable
    private final Query query;
    private final Map<String, List<RuntimeField>> runtimeMappings;
    @Nullable
    private final DataframeAnalysisAnalyzedFields source;
    public static final JsonpDeserializer<DataframeAnalyticsSource> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, DataframeAnalyticsSource::setupDataframeAnalyticsSourceDeserializer);

    private DataframeAnalyticsSource(Builder builder) {
        this.index = ApiTypeHelper.unmodifiableRequired(builder.index, (Object)this, "index");
        this.query = builder.query;
        this.runtimeMappings = ApiTypeHelper.unmodifiable(builder.runtimeMappings);
        this.source = builder.source;
    }

    public static DataframeAnalyticsSource of(Function<Builder, ObjectBuilder<DataframeAnalyticsSource>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final List<String> index() {
        return this.index;
    }

    @Nullable
    public final Query query() {
        return this.query;
    }

    public final Map<String, List<RuntimeField>> runtimeMappings() {
        return this.runtimeMappings;
    }

    @Nullable
    public final DataframeAnalysisAnalyzedFields source() {
        return this.source;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (ApiTypeHelper.isDefined(this.index)) {
            generator.writeKey("index");
            generator.writeStartArray();
            for (String string : this.index) {
                generator.write(string);
            }
            generator.writeEnd();
        }
        if (this.query != null) {
            generator.writeKey("query");
            this.query.serialize(generator, mapper);
        }
        if (ApiTypeHelper.isDefined(this.runtimeMappings)) {
            generator.writeKey("runtime_mappings");
            generator.writeStartObject();
            for (Map.Entry entry : this.runtimeMappings.entrySet()) {
                generator.writeKey((String)entry.getKey());
                generator.writeStartArray();
                if (entry.getValue() != null) {
                    for (RuntimeField item1 : (List)entry.getValue()) {
                        item1.serialize(generator, mapper);
                    }
                }
                generator.writeEnd();
            }
            generator.writeEnd();
        }
        if (this.source != null) {
            generator.writeKey("_source");
            this.source.serialize(generator, mapper);
        }
    }

    protected static void setupDataframeAnalyticsSourceDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::index, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "index");
        op.add(Builder::query, Query._DESERIALIZER, "query");
        op.add(Builder::runtimeMappings, JsonpDeserializer.stringMapDeserializer(JsonpDeserializer.arrayDeserializer(RuntimeField._DESERIALIZER)), "runtime_mappings");
        op.add(Builder::source, DataframeAnalysisAnalyzedFields._DESERIALIZER, "_source");
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<DataframeAnalyticsSource> {
        private List<String> index;
        @Nullable
        private Query query;
        @Nullable
        private Map<String, List<RuntimeField>> runtimeMappings;
        @Nullable
        private DataframeAnalysisAnalyzedFields source;

        public final Builder index(List<String> list) {
            this.index = Builder._listAddAll(this.index, list);
            return this;
        }

        public final Builder index(String value, String ... values) {
            this.index = Builder._listAdd(this.index, value, values);
            return this;
        }

        public final Builder query(@Nullable Query value) {
            this.query = value;
            return this;
        }

        public final Builder query(Function<Query.Builder, ObjectBuilder<Query>> fn) {
            return this.query(fn.apply(new Query.Builder()).build());
        }

        public final Builder runtimeMappings(Map<String, List<RuntimeField>> map) {
            this.runtimeMappings = Builder._mapPutAll(this.runtimeMappings, map);
            return this;
        }

        public final Builder runtimeMappings(String key, List<RuntimeField> value) {
            this.runtimeMappings = Builder._mapPut(this.runtimeMappings, key, value);
            return this;
        }

        public final Builder source(@Nullable DataframeAnalysisAnalyzedFields value) {
            this.source = value;
            return this;
        }

        public final Builder source(Function<DataframeAnalysisAnalyzedFields.Builder, ObjectBuilder<DataframeAnalysisAnalyzedFields>> fn) {
            return this.source(fn.apply(new DataframeAnalysisAnalyzedFields.Builder()).build());
        }

        @Override
        public DataframeAnalyticsSource build() {
            this._checkSingleUse();
            return new DataframeAnalyticsSource(this);
        }
    }
}

