/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.license;

import co.elastic.clients.elasticsearch.license.LicenseType;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.DateTime;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.ObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class License
implements JsonpSerializable {
    private final DateTime expiryDateInMillis;
    private final DateTime issueDateInMillis;
    @Nullable
    private final DateTime startDateInMillis;
    private final String issuedTo;
    private final String issuer;
    @Nullable
    private final Long maxNodes;
    @Nullable
    private final Long maxResourceUnits;
    private final String signature;
    private final LicenseType type;
    private final String uid;
    public static final JsonpDeserializer<License> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, License::setupLicenseDeserializer);

    private License(Builder builder) {
        this.expiryDateInMillis = ApiTypeHelper.requireNonNull(builder.expiryDateInMillis, this, "expiryDateInMillis");
        this.issueDateInMillis = ApiTypeHelper.requireNonNull(builder.issueDateInMillis, this, "issueDateInMillis");
        this.startDateInMillis = builder.startDateInMillis;
        this.issuedTo = ApiTypeHelper.requireNonNull(builder.issuedTo, this, "issuedTo");
        this.issuer = ApiTypeHelper.requireNonNull(builder.issuer, this, "issuer");
        this.maxNodes = builder.maxNodes;
        this.maxResourceUnits = builder.maxResourceUnits;
        this.signature = ApiTypeHelper.requireNonNull(builder.signature, this, "signature");
        this.type = ApiTypeHelper.requireNonNull(builder.type, this, "type");
        this.uid = ApiTypeHelper.requireNonNull(builder.uid, this, "uid");
    }

    public static License of(Function<Builder, ObjectBuilder<License>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final DateTime expiryDateInMillis() {
        return this.expiryDateInMillis;
    }

    public final DateTime issueDateInMillis() {
        return this.issueDateInMillis;
    }

    @Nullable
    public final DateTime startDateInMillis() {
        return this.startDateInMillis;
    }

    public final String issuedTo() {
        return this.issuedTo;
    }

    public final String issuer() {
        return this.issuer;
    }

    @Nullable
    public final Long maxNodes() {
        return this.maxNodes;
    }

    @Nullable
    public final Long maxResourceUnits() {
        return this.maxResourceUnits;
    }

    public final String signature() {
        return this.signature;
    }

    public final LicenseType type() {
        return this.type;
    }

    public final String uid() {
        return this.uid;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("expiry_date_in_millis");
        this.expiryDateInMillis.serialize(generator, mapper);
        generator.writeKey("issue_date_in_millis");
        this.issueDateInMillis.serialize(generator, mapper);
        if (this.startDateInMillis != null) {
            generator.writeKey("start_date_in_millis");
            this.startDateInMillis.serialize(generator, mapper);
        }
        generator.writeKey("issued_to");
        generator.write(this.issuedTo);
        generator.writeKey("issuer");
        generator.write(this.issuer);
        if (this.maxNodes != null) {
            generator.writeKey("max_nodes");
            generator.write(this.maxNodes.longValue());
        }
        if (this.maxResourceUnits != null) {
            generator.writeKey("max_resource_units");
            generator.write(this.maxResourceUnits.longValue());
        }
        generator.writeKey("signature");
        generator.write(this.signature);
        generator.writeKey("type");
        this.type.serialize(generator, mapper);
        generator.writeKey("uid");
        generator.write(this.uid);
    }

    protected static void setupLicenseDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::expiryDateInMillis, DateTime._DESERIALIZER, "expiry_date_in_millis");
        op.add(Builder::issueDateInMillis, DateTime._DESERIALIZER, "issue_date_in_millis");
        op.add(Builder::startDateInMillis, DateTime._DESERIALIZER, "start_date_in_millis");
        op.add(Builder::issuedTo, JsonpDeserializer.stringDeserializer(), "issued_to");
        op.add(Builder::issuer, JsonpDeserializer.stringDeserializer(), "issuer");
        op.add(Builder::maxNodes, JsonpDeserializer.longDeserializer(), "max_nodes");
        op.add(Builder::maxResourceUnits, JsonpDeserializer.longDeserializer(), "max_resource_units");
        op.add(Builder::signature, JsonpDeserializer.stringDeserializer(), "signature");
        op.add(Builder::type, LicenseType._DESERIALIZER, "type");
        op.add(Builder::uid, JsonpDeserializer.stringDeserializer(), "uid");
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<License> {
        private DateTime expiryDateInMillis;
        private DateTime issueDateInMillis;
        @Nullable
        private DateTime startDateInMillis;
        private String issuedTo;
        private String issuer;
        @Nullable
        private Long maxNodes;
        @Nullable
        private Long maxResourceUnits;
        private String signature;
        private LicenseType type;
        private String uid;

        public final Builder expiryDateInMillis(DateTime value) {
            this.expiryDateInMillis = value;
            return this;
        }

        public final Builder issueDateInMillis(DateTime value) {
            this.issueDateInMillis = value;
            return this;
        }

        public final Builder startDateInMillis(@Nullable DateTime value) {
            this.startDateInMillis = value;
            return this;
        }

        public final Builder issuedTo(String value) {
            this.issuedTo = value;
            return this;
        }

        public final Builder issuer(String value) {
            this.issuer = value;
            return this;
        }

        public final Builder maxNodes(@Nullable Long value) {
            this.maxNodes = value;
            return this;
        }

        public final Builder maxResourceUnits(@Nullable Long value) {
            this.maxResourceUnits = value;
            return this;
        }

        public final Builder signature(String value) {
            this.signature = value;
            return this;
        }

        public final Builder type(LicenseType value) {
            this.type = value;
            return this;
        }

        public final Builder uid(String value) {
            this.uid = value;
            return this;
        }

        @Override
        public License build() {
            this._checkSingleUse();
            return new License(this);
        }
    }
}

