/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.indices;

import co.elastic.clients.elasticsearch.indices.RetentionLease;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.ObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class SoftDeletes
implements JsonpSerializable {
    private final boolean enabled;
    @Nullable
    private final RetentionLease retentionLease;
    public static final JsonpDeserializer<SoftDeletes> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, SoftDeletes::setupSoftDeletesDeserializer);

    private SoftDeletes(Builder builder) {
        this.enabled = ApiTypeHelper.requireNonNull(builder.enabled, this, "enabled");
        this.retentionLease = builder.retentionLease;
    }

    public static SoftDeletes of(Function<Builder, ObjectBuilder<SoftDeletes>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final boolean enabled() {
        return this.enabled;
    }

    @Nullable
    public final RetentionLease retentionLease() {
        return this.retentionLease;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("enabled");
        generator.write(this.enabled);
        if (this.retentionLease != null) {
            generator.writeKey("retention_lease");
            this.retentionLease.serialize(generator, mapper);
        }
    }

    protected static void setupSoftDeletesDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::enabled, JsonpDeserializer.booleanDeserializer(), "enabled");
        op.add(Builder::retentionLease, RetentionLease._DESERIALIZER, "retention_lease");
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<SoftDeletes> {
        private Boolean enabled;
        @Nullable
        private RetentionLease retentionLease;

        public final Builder enabled(boolean value) {
            this.enabled = value;
            return this;
        }

        public final Builder retentionLease(@Nullable RetentionLease value) {
            this.retentionLease = value;
            return this;
        }

        public final Builder retentionLease(Function<RetentionLease.Builder, ObjectBuilder<RetentionLease>> fn) {
            return this.retentionLease(fn.apply(new RetentionLease.Builder()).build());
        }

        @Override
        public SoftDeletes build() {
            this._checkSingleUse();
            return new SoftDeletes(this);
        }
    }
}

