/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.indices;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.DateTime;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.ObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class IndexSettingsTimeSeries
implements JsonpSerializable {
    @Nullable
    private final DateTime endTime;
    @Nullable
    private final DateTime startTime;
    public static final JsonpDeserializer<IndexSettingsTimeSeries> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, IndexSettingsTimeSeries::setupIndexSettingsTimeSeriesDeserializer);

    private IndexSettingsTimeSeries(Builder builder) {
        this.endTime = builder.endTime;
        this.startTime = builder.startTime;
    }

    public static IndexSettingsTimeSeries of(Function<Builder, ObjectBuilder<IndexSettingsTimeSeries>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final DateTime endTime() {
        return this.endTime;
    }

    @Nullable
    public final DateTime startTime() {
        return this.startTime;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.endTime != null) {
            generator.writeKey("end_time");
            this.endTime.serialize(generator, mapper);
        }
        if (this.startTime != null) {
            generator.writeKey("start_time");
            this.startTime.serialize(generator, mapper);
        }
    }

    protected static void setupIndexSettingsTimeSeriesDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::endTime, DateTime._DESERIALIZER, "end_time");
        op.add(Builder::startTime, DateTime._DESERIALIZER, "start_time");
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<IndexSettingsTimeSeries> {
        @Nullable
        private DateTime endTime;
        @Nullable
        private DateTime startTime;

        public final Builder endTime(@Nullable DateTime value) {
            this.endTime = value;
            return this;
        }

        public final Builder startTime(@Nullable DateTime value) {
            this.startTime = value;
            return this;
        }

        @Override
        public IndexSettingsTimeSeries build() {
            this._checkSingleUse();
            return new IndexSettingsTimeSeries(this);
        }
    }
}

