/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.core.search;

import co.elastic.clients.elasticsearch.core.search.QueryBreakdown;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.ObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class QueryProfile
implements JsonpSerializable {
    private final QueryBreakdown breakdown;
    private final String description;
    private final long timeInNanos;
    private final String type;
    private final List<QueryProfile> children;
    public static final JsonpDeserializer<QueryProfile> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, QueryProfile::setupQueryProfileDeserializer);

    private QueryProfile(Builder builder) {
        this.breakdown = ApiTypeHelper.requireNonNull(builder.breakdown, this, "breakdown");
        this.description = ApiTypeHelper.requireNonNull(builder.description, this, "description");
        this.timeInNanos = ApiTypeHelper.requireNonNull(builder.timeInNanos, this, "timeInNanos");
        this.type = ApiTypeHelper.requireNonNull(builder.type, this, "type");
        this.children = ApiTypeHelper.unmodifiable(builder.children);
    }

    public static QueryProfile of(Function<Builder, ObjectBuilder<QueryProfile>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final QueryBreakdown breakdown() {
        return this.breakdown;
    }

    public final String description() {
        return this.description;
    }

    public final long timeInNanos() {
        return this.timeInNanos;
    }

    public final String type() {
        return this.type;
    }

    public final List<QueryProfile> children() {
        return this.children;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("breakdown");
        this.breakdown.serialize(generator, mapper);
        generator.writeKey("description");
        generator.write(this.description);
        generator.writeKey("time_in_nanos");
        generator.write(this.timeInNanos);
        generator.writeKey("type");
        generator.write(this.type);
        if (ApiTypeHelper.isDefined(this.children)) {
            generator.writeKey("children");
            generator.writeStartArray();
            for (QueryProfile item0 : this.children) {
                item0.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    protected static void setupQueryProfileDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::breakdown, QueryBreakdown._DESERIALIZER, "breakdown");
        op.add(Builder::description, JsonpDeserializer.stringDeserializer(), "description");
        op.add(Builder::timeInNanos, JsonpDeserializer.longDeserializer(), "time_in_nanos");
        op.add(Builder::type, JsonpDeserializer.stringDeserializer(), "type");
        op.add(Builder::children, JsonpDeserializer.arrayDeserializer(_DESERIALIZER), "children");
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<QueryProfile> {
        private QueryBreakdown breakdown;
        private String description;
        private Long timeInNanos;
        private String type;
        @Nullable
        private List<QueryProfile> children;

        public final Builder breakdown(QueryBreakdown value) {
            this.breakdown = value;
            return this;
        }

        public final Builder breakdown(Function<QueryBreakdown.Builder, ObjectBuilder<QueryBreakdown>> fn) {
            return this.breakdown(fn.apply(new QueryBreakdown.Builder()).build());
        }

        public final Builder description(String value) {
            this.description = value;
            return this;
        }

        public final Builder timeInNanos(long value) {
            this.timeInNanos = value;
            return this;
        }

        public final Builder type(String value) {
            this.type = value;
            return this;
        }

        public final Builder children(List<QueryProfile> list) {
            this.children = Builder._listAddAll(this.children, list);
            return this;
        }

        public final Builder children(QueryProfile value, QueryProfile ... values) {
            this.children = Builder._listAdd(this.children, value, values);
            return this;
        }

        public final Builder children(Function<Builder, ObjectBuilder<QueryProfile>> fn) {
            return this.children(fn.apply(new Builder()).build(), new QueryProfile[0]);
        }

        @Override
        public QueryProfile build() {
            this._checkSingleUse();
            return new QueryProfile(this);
        }
    }
}

