/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.core;

import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch._types.OpType;
import co.elastic.clients.elasticsearch._types.Refresh;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch._types.Time;
import co.elastic.clients.elasticsearch._types.VersionType;
import co.elastic.clients.elasticsearch._types.WaitForActiveShards;
import co.elastic.clients.elasticsearch.core.IndexResponse;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpSerializer;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.ObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import jakarta.json.stream.JsonParser;
import java.util.HashMap;
import java.util.function.Function;
import javax.annotation.Nullable;

public class IndexRequest<TDocument>
extends RequestBase
implements JsonpSerializable {
    @Nullable
    private final String id;
    @Nullable
    private final Long ifPrimaryTerm;
    @Nullable
    private final Long ifSeqNo;
    private final String index;
    @Nullable
    private final OpType opType;
    @Nullable
    private final String pipeline;
    @Nullable
    private final Refresh refresh;
    @Nullable
    private final Boolean requireAlias;
    @Nullable
    private final String routing;
    @Nullable
    private final Time timeout;
    @Nullable
    private final Long version;
    @Nullable
    private final VersionType versionType;
    @Nullable
    private final WaitForActiveShards waitForActiveShards;
    private final TDocument document;
    @Nullable
    private final JsonpSerializer<TDocument> tDocumentSerializer;
    public static final Endpoint<IndexRequest<?>, IndexResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<IndexRequest, IndexResponse>("es/index", request -> {
        boolean _index = true;
        int _id = 2;
        int propsSet = 0;
        propsSet |= 1;
        if (request.id() != null) {
            propsSet |= 2;
        }
        if (propsSet == 3) {
            return "PUT";
        }
        if (propsSet == 1) {
            return "POST";
        }
        throw SimpleEndpoint.noPathTemplateFound("method");
    }, request -> {
        boolean _index = true;
        int _id = 2;
        int propsSet = 0;
        propsSet |= 1;
        if (request.id() != null) {
            propsSet |= 2;
        }
        if (propsSet == 3) {
            StringBuilder buf = new StringBuilder();
            buf.append("/");
            SimpleEndpoint.pathEncode(request.index, buf);
            buf.append("/_doc");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.id, buf);
            return buf.toString();
        }
        if (propsSet == 1) {
            StringBuilder buf = new StringBuilder();
            buf.append("/");
            SimpleEndpoint.pathEncode(request.index, buf);
            buf.append("/_doc");
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.pipeline != null) {
            params.put("pipeline", request.pipeline);
        }
        if (request.routing != null) {
            params.put("routing", request.routing);
        }
        if (request.requireAlias != null) {
            params.put("require_alias", String.valueOf(request.requireAlias));
        }
        if (request.versionType != null) {
            params.put("version_type", request.versionType.jsonValue());
        }
        if (request.ifPrimaryTerm != null) {
            params.put("if_primary_term", String.valueOf(request.ifPrimaryTerm));
        }
        if (request.ifSeqNo != null) {
            params.put("if_seq_no", String.valueOf(request.ifSeqNo));
        }
        if (request.refresh != null) {
            params.put("refresh", request.refresh.jsonValue());
        }
        if (request.waitForActiveShards != null) {
            params.put("wait_for_active_shards", request.waitForActiveShards._toJsonString());
        }
        if (request.opType != null) {
            params.put("op_type", request.opType.jsonValue());
        }
        if (request.version != null) {
            params.put("version", String.valueOf(request.version));
        }
        if (request.timeout != null) {
            params.put("timeout", request.timeout._toJsonString());
        }
        return params;
    }, SimpleEndpoint.emptyMap(), true, IndexResponse._DESERIALIZER);

    private IndexRequest(Builder<TDocument> builder) {
        this.id = ((Builder)builder).id;
        this.ifPrimaryTerm = ((Builder)builder).ifPrimaryTerm;
        this.ifSeqNo = ((Builder)builder).ifSeqNo;
        this.index = ApiTypeHelper.requireNonNull(((Builder)builder).index, this, "index");
        this.opType = ((Builder)builder).opType;
        this.pipeline = ((Builder)builder).pipeline;
        this.refresh = ((Builder)builder).refresh;
        this.requireAlias = ((Builder)builder).requireAlias;
        this.routing = ((Builder)builder).routing;
        this.timeout = ((Builder)builder).timeout;
        this.version = ((Builder)builder).version;
        this.versionType = ((Builder)builder).versionType;
        this.waitForActiveShards = ((Builder)builder).waitForActiveShards;
        this.document = ApiTypeHelper.requireNonNull(((Builder)builder).document, this, "document");
        this.tDocumentSerializer = ((Builder)builder).tDocumentSerializer;
    }

    public static <TDocument> IndexRequest<TDocument> of(Function<Builder<TDocument>, ObjectBuilder<IndexRequest<TDocument>>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final String id() {
        return this.id;
    }

    @Nullable
    public final Long ifPrimaryTerm() {
        return this.ifPrimaryTerm;
    }

    @Nullable
    public final Long ifSeqNo() {
        return this.ifSeqNo;
    }

    public final String index() {
        return this.index;
    }

    @Nullable
    public final OpType opType() {
        return this.opType;
    }

    @Nullable
    public final String pipeline() {
        return this.pipeline;
    }

    @Nullable
    public final Refresh refresh() {
        return this.refresh;
    }

    @Nullable
    public final Boolean requireAlias() {
        return this.requireAlias;
    }

    @Nullable
    public final String routing() {
        return this.routing;
    }

    @Nullable
    public final Time timeout() {
        return this.timeout;
    }

    @Nullable
    public final Long version() {
        return this.version;
    }

    @Nullable
    public final VersionType versionType() {
        return this.versionType;
    }

    @Nullable
    public final WaitForActiveShards waitForActiveShards() {
        return this.waitForActiveShards;
    }

    public final TDocument document() {
        return this.document;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        JsonpUtils.serialize(this.document, generator, this.tDocumentSerializer, mapper);
    }

    public static <TDocument> JsonpDeserializer<IndexRequest<TDocument>> createIndexRequestDeserializer(JsonpDeserializer<TDocument> tDocumentDeserializer) {
        JsonpDeserializer valueDeserializer = tDocumentDeserializer;
        return JsonpDeserializer.of(valueDeserializer.acceptedEvents(), (parser, mapper) -> new Builder().document(valueDeserializer.deserialize((JsonParser)parser, (JsonpMapper)mapper)).build());
    }

    public static class Builder<TDocument>
    extends ObjectBuilderBase
    implements ObjectBuilder<IndexRequest<TDocument>> {
        @Nullable
        private String id;
        @Nullable
        private Long ifPrimaryTerm;
        @Nullable
        private Long ifSeqNo;
        private String index;
        @Nullable
        private OpType opType;
        @Nullable
        private String pipeline;
        @Nullable
        private Refresh refresh;
        @Nullable
        private Boolean requireAlias;
        @Nullable
        private String routing;
        @Nullable
        private Time timeout;
        @Nullable
        private Long version;
        @Nullable
        private VersionType versionType;
        @Nullable
        private WaitForActiveShards waitForActiveShards;
        private TDocument document;
        @Nullable
        private JsonpSerializer<TDocument> tDocumentSerializer;

        public final Builder<TDocument> id(@Nullable String value) {
            this.id = value;
            return this;
        }

        public final Builder<TDocument> ifPrimaryTerm(@Nullable Long value) {
            this.ifPrimaryTerm = value;
            return this;
        }

        public final Builder<TDocument> ifSeqNo(@Nullable Long value) {
            this.ifSeqNo = value;
            return this;
        }

        public final Builder<TDocument> index(String value) {
            this.index = value;
            return this;
        }

        public final Builder<TDocument> opType(@Nullable OpType value) {
            this.opType = value;
            return this;
        }

        public final Builder<TDocument> pipeline(@Nullable String value) {
            this.pipeline = value;
            return this;
        }

        public final Builder<TDocument> refresh(@Nullable Refresh value) {
            this.refresh = value;
            return this;
        }

        public final Builder<TDocument> requireAlias(@Nullable Boolean value) {
            this.requireAlias = value;
            return this;
        }

        public final Builder<TDocument> routing(@Nullable String value) {
            this.routing = value;
            return this;
        }

        public final Builder<TDocument> timeout(@Nullable Time value) {
            this.timeout = value;
            return this;
        }

        public final Builder<TDocument> timeout(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.timeout(fn.apply(new Time.Builder()).build());
        }

        public final Builder<TDocument> version(@Nullable Long value) {
            this.version = value;
            return this;
        }

        public final Builder<TDocument> versionType(@Nullable VersionType value) {
            this.versionType = value;
            return this;
        }

        public final Builder<TDocument> waitForActiveShards(@Nullable WaitForActiveShards value) {
            this.waitForActiveShards = value;
            return this;
        }

        public final Builder<TDocument> waitForActiveShards(Function<WaitForActiveShards.Builder, ObjectBuilder<WaitForActiveShards>> fn) {
            return this.waitForActiveShards(fn.apply(new WaitForActiveShards.Builder()).build());
        }

        public final Builder<TDocument> document(TDocument value) {
            this.document = value;
            return this;
        }

        public final Builder<TDocument> tDocumentSerializer(@Nullable JsonpSerializer<TDocument> value) {
            this.tDocumentSerializer = value;
            return this;
        }

        @Override
        public IndexRequest<TDocument> build() {
            this._checkSingleUse();
            return new IndexRequest(this);
        }
    }
}

