/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.nodes;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.ObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class Pool
implements JsonpSerializable {
    @Nullable
    private final Long usedInBytes;
    @Nullable
    private final Long maxInBytes;
    @Nullable
    private final Long peakUsedInBytes;
    @Nullable
    private final Long peakMaxInBytes;
    public static final JsonpDeserializer<Pool> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, Pool::setupPoolDeserializer);

    private Pool(Builder builder) {
        this.usedInBytes = builder.usedInBytes;
        this.maxInBytes = builder.maxInBytes;
        this.peakUsedInBytes = builder.peakUsedInBytes;
        this.peakMaxInBytes = builder.peakMaxInBytes;
    }

    public static Pool of(Function<Builder, ObjectBuilder<Pool>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Long usedInBytes() {
        return this.usedInBytes;
    }

    @Nullable
    public final Long maxInBytes() {
        return this.maxInBytes;
    }

    @Nullable
    public final Long peakUsedInBytes() {
        return this.peakUsedInBytes;
    }

    @Nullable
    public final Long peakMaxInBytes() {
        return this.peakMaxInBytes;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.usedInBytes != null) {
            generator.writeKey("used_in_bytes");
            generator.write(this.usedInBytes.longValue());
        }
        if (this.maxInBytes != null) {
            generator.writeKey("max_in_bytes");
            generator.write(this.maxInBytes.longValue());
        }
        if (this.peakUsedInBytes != null) {
            generator.writeKey("peak_used_in_bytes");
            generator.write(this.peakUsedInBytes.longValue());
        }
        if (this.peakMaxInBytes != null) {
            generator.writeKey("peak_max_in_bytes");
            generator.write(this.peakMaxInBytes.longValue());
        }
    }

    protected static void setupPoolDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::usedInBytes, JsonpDeserializer.longDeserializer(), "used_in_bytes");
        op.add(Builder::maxInBytes, JsonpDeserializer.longDeserializer(), "max_in_bytes");
        op.add(Builder::peakUsedInBytes, JsonpDeserializer.longDeserializer(), "peak_used_in_bytes");
        op.add(Builder::peakMaxInBytes, JsonpDeserializer.longDeserializer(), "peak_max_in_bytes");
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<Pool> {
        @Nullable
        private Long usedInBytes;
        @Nullable
        private Long maxInBytes;
        @Nullable
        private Long peakUsedInBytes;
        @Nullable
        private Long peakMaxInBytes;

        public final Builder usedInBytes(@Nullable Long value) {
            this.usedInBytes = value;
            return this;
        }

        public final Builder maxInBytes(@Nullable Long value) {
            this.maxInBytes = value;
            return this;
        }

        public final Builder peakUsedInBytes(@Nullable Long value) {
            this.peakUsedInBytes = value;
            return this;
        }

        public final Builder peakMaxInBytes(@Nullable Long value) {
            this.peakMaxInBytes = value;
            return this;
        }

        @Override
        public Pool build() {
            this._checkSingleUse();
            return new Pool(this);
        }
    }
}

