/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml.put_trained_model;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.ObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;

@JsonpDeserializable
public class Input
implements JsonpSerializable {
    private final List<String> fieldNames;
    public static final JsonpDeserializer<Input> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, Input::setupInputDeserializer);

    private Input(Builder builder) {
        this.fieldNames = ApiTypeHelper.unmodifiableRequired(builder.fieldNames, (Object)this, "fieldNames");
    }

    public static Input of(Function<Builder, ObjectBuilder<Input>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final List<String> fieldNames() {
        return this.fieldNames;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (ApiTypeHelper.isDefined(this.fieldNames)) {
            generator.writeKey("field_names");
            generator.writeStartArray();
            for (String item0 : this.fieldNames) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
    }

    protected static void setupInputDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::fieldNames, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "field_names");
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<Input> {
        private List<String> fieldNames;

        public final Builder fieldNames(List<String> list) {
            this.fieldNames = Builder._listAddAll(this.fieldNames, list);
            return this;
        }

        public final Builder fieldNames(String value, String ... values) {
            this.fieldNames = Builder._listAdd(this.fieldNames, value, values);
            return this;
        }

        @Override
        public Input build() {
            this._checkSingleUse();
            return new Input(this);
        }
    }
}

