/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ilm;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.ObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;

@JsonpDeserializable
public class RemovePolicyResponse
implements JsonpSerializable {
    private final List<String> failedIndexes;
    private final boolean hasFailures;
    public static final JsonpDeserializer<RemovePolicyResponse> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, RemovePolicyResponse::setupRemovePolicyResponseDeserializer);

    private RemovePolicyResponse(Builder builder) {
        this.failedIndexes = ApiTypeHelper.unmodifiableRequired(builder.failedIndexes, (Object)this, "failedIndexes");
        this.hasFailures = ApiTypeHelper.requireNonNull(builder.hasFailures, this, "hasFailures");
    }

    public static RemovePolicyResponse of(Function<Builder, ObjectBuilder<RemovePolicyResponse>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final List<String> failedIndexes() {
        return this.failedIndexes;
    }

    public final boolean hasFailures() {
        return this.hasFailures;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (ApiTypeHelper.isDefined(this.failedIndexes)) {
            generator.writeKey("failed_indexes");
            generator.writeStartArray();
            for (String item0 : this.failedIndexes) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
        generator.writeKey("has_failures");
        generator.write(this.hasFailures);
    }

    protected static void setupRemovePolicyResponseDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::failedIndexes, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "failed_indexes");
        op.add(Builder::hasFailures, JsonpDeserializer.booleanDeserializer(), "has_failures");
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<RemovePolicyResponse> {
        private List<String> failedIndexes;
        private Boolean hasFailures;

        public final Builder failedIndexes(List<String> list) {
            this.failedIndexes = Builder._listAddAll(this.failedIndexes, list);
            return this;
        }

        public final Builder failedIndexes(String value, String ... values) {
            this.failedIndexes = Builder._listAdd(this.failedIndexes, value, values);
            return this;
        }

        public final Builder hasFailures(boolean value) {
            this.hasFailures = value;
            return this;
        }

        @Override
        public RemovePolicyResponse build() {
            this._checkSingleUse();
            return new RemovePolicyResponse(this);
        }
    }
}

