/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.core;

import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch._types.ExpandWildcard;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch._types.SearchType;
import co.elastic.clients.elasticsearch._types.Time;
import co.elastic.clients.elasticsearch.core.SearchTemplateResponse;
import co.elastic.clients.json.JsonData;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.ObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

@JsonpDeserializable
public class SearchTemplateRequest
extends RequestBase
implements JsonpSerializable {
    @Nullable
    private final Boolean allowNoIndices;
    @Nullable
    private final Boolean ccsMinimizeRoundtrips;
    private final List<ExpandWildcard> expandWildcards;
    @Nullable
    private final Boolean explain;
    @Nullable
    private final String id;
    @Nullable
    private final Boolean ignoreThrottled;
    @Nullable
    private final Boolean ignoreUnavailable;
    private final List<String> index;
    private final Map<String, JsonData> params;
    @Nullable
    private final String preference;
    @Nullable
    private final Boolean profile;
    @Nullable
    private final String routing;
    @Nullable
    private final Time scroll;
    @Nullable
    private final SearchType searchType;
    @Nullable
    private final String source;
    public static final JsonpDeserializer<SearchTemplateRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, SearchTemplateRequest::setupSearchTemplateRequestDeserializer);
    public static final SimpleEndpoint<SearchTemplateRequest, ?> _ENDPOINT = new SimpleEndpoint<SearchTemplateRequest, SearchTemplateResponse<Object>>("es/search_template", request -> "POST", request -> {
        boolean _index = true;
        boolean propsSet = false;
        if (ApiTypeHelper.isDefined(request.index())) {
            propsSet |= true;
        }
        if (!propsSet) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_search");
            buf.append("/template");
            return buf.toString();
        }
        if (propsSet) {
            StringBuilder buf = new StringBuilder();
            buf.append("/");
            SimpleEndpoint.pathEncode(request.index.stream().map(v -> v).collect(Collectors.joining(",")), buf);
            buf.append("/_search");
            buf.append("/template");
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("typed_keys", "true");
        if (ApiTypeHelper.isDefined(request.expandWildcards)) {
            params.put("expand_wildcards", request.expandWildcards.stream().map(v -> v.jsonValue()).collect(Collectors.joining(",")));
        }
        if (request.preference != null) {
            params.put("preference", request.preference);
        }
        if (request.scroll != null) {
            params.put("scroll", request.scroll._toJsonString());
        }
        if (request.searchType != null) {
            params.put("search_type", request.searchType.jsonValue());
        }
        if (request.ccsMinimizeRoundtrips != null) {
            params.put("ccs_minimize_roundtrips", String.valueOf(request.ccsMinimizeRoundtrips));
        }
        if (request.routing != null) {
            params.put("routing", request.routing);
        }
        if (request.ignoreUnavailable != null) {
            params.put("ignore_unavailable", String.valueOf(request.ignoreUnavailable));
        }
        if (request.allowNoIndices != null) {
            params.put("allow_no_indices", String.valueOf(request.allowNoIndices));
        }
        if (request.ignoreThrottled != null) {
            params.put("ignore_throttled", String.valueOf(request.ignoreThrottled));
        }
        return params;
    }, SimpleEndpoint.emptyMap(), true, SearchTemplateResponse._DESERIALIZER);

    private SearchTemplateRequest(Builder builder) {
        this.allowNoIndices = builder.allowNoIndices;
        this.ccsMinimizeRoundtrips = builder.ccsMinimizeRoundtrips;
        this.expandWildcards = ApiTypeHelper.unmodifiable(builder.expandWildcards);
        this.explain = builder.explain;
        this.id = builder.id;
        this.ignoreThrottled = builder.ignoreThrottled;
        this.ignoreUnavailable = builder.ignoreUnavailable;
        this.index = ApiTypeHelper.unmodifiable(builder.index);
        this.params = ApiTypeHelper.unmodifiable(builder.params);
        this.preference = builder.preference;
        this.profile = builder.profile;
        this.routing = builder.routing;
        this.scroll = builder.scroll;
        this.searchType = builder.searchType;
        this.source = builder.source;
    }

    public static SearchTemplateRequest of(Function<Builder, ObjectBuilder<SearchTemplateRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Boolean allowNoIndices() {
        return this.allowNoIndices;
    }

    @Nullable
    public final Boolean ccsMinimizeRoundtrips() {
        return this.ccsMinimizeRoundtrips;
    }

    public final List<ExpandWildcard> expandWildcards() {
        return this.expandWildcards;
    }

    @Nullable
    public final Boolean explain() {
        return this.explain;
    }

    @Nullable
    public final String id() {
        return this.id;
    }

    @Nullable
    public final Boolean ignoreThrottled() {
        return this.ignoreThrottled;
    }

    @Nullable
    public final Boolean ignoreUnavailable() {
        return this.ignoreUnavailable;
    }

    public final List<String> index() {
        return this.index;
    }

    public final Map<String, JsonData> params() {
        return this.params;
    }

    @Nullable
    public final String preference() {
        return this.preference;
    }

    @Nullable
    public final Boolean profile() {
        return this.profile;
    }

    @Nullable
    public final String routing() {
        return this.routing;
    }

    @Nullable
    public final Time scroll() {
        return this.scroll;
    }

    @Nullable
    public final SearchType searchType() {
        return this.searchType;
    }

    @Nullable
    public final String source() {
        return this.source;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.explain != null) {
            generator.writeKey("explain");
            generator.write(this.explain.booleanValue());
        }
        if (this.id != null) {
            generator.writeKey("id");
            generator.write(this.id);
        }
        if (ApiTypeHelper.isDefined(this.params)) {
            generator.writeKey("params");
            generator.writeStartObject();
            for (Map.Entry<String, JsonData> item0 : this.params.entrySet()) {
                generator.writeKey(item0.getKey());
                item0.getValue().serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.profile != null) {
            generator.writeKey("profile");
            generator.write(this.profile.booleanValue());
        }
        if (this.source != null) {
            generator.writeKey("source");
            generator.write(this.source);
        }
    }

    protected static void setupSearchTemplateRequestDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::explain, JsonpDeserializer.booleanDeserializer(), "explain");
        op.add(Builder::id, JsonpDeserializer.stringDeserializer(), "id");
        op.add(Builder::params, JsonpDeserializer.stringMapDeserializer(JsonData._DESERIALIZER), "params");
        op.add(Builder::profile, JsonpDeserializer.booleanDeserializer(), "profile");
        op.add(Builder::source, JsonpDeserializer.stringDeserializer(), "source");
    }

    public static <TDocument> Endpoint<SearchTemplateRequest, SearchTemplateResponse<TDocument>, ErrorResponse> createSearchTemplateEndpoint(JsonpDeserializer<TDocument> tDocumentDeserializer) {
        return _ENDPOINT.withResponseDeserializer(SearchTemplateResponse.createSearchTemplateResponseDeserializer(tDocumentDeserializer));
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<SearchTemplateRequest> {
        @Nullable
        private Boolean allowNoIndices;
        @Nullable
        private Boolean ccsMinimizeRoundtrips;
        @Nullable
        private List<ExpandWildcard> expandWildcards;
        @Nullable
        private Boolean explain;
        @Nullable
        private String id;
        @Nullable
        private Boolean ignoreThrottled;
        @Nullable
        private Boolean ignoreUnavailable;
        @Nullable
        private List<String> index;
        @Nullable
        private Map<String, JsonData> params;
        @Nullable
        private String preference;
        @Nullable
        private Boolean profile;
        @Nullable
        private String routing;
        @Nullable
        private Time scroll;
        @Nullable
        private SearchType searchType;
        @Nullable
        private String source;

        public final Builder allowNoIndices(@Nullable Boolean value) {
            this.allowNoIndices = value;
            return this;
        }

        public final Builder ccsMinimizeRoundtrips(@Nullable Boolean value) {
            this.ccsMinimizeRoundtrips = value;
            return this;
        }

        public final Builder expandWildcards(List<ExpandWildcard> list) {
            this.expandWildcards = Builder._listAddAll(this.expandWildcards, list);
            return this;
        }

        public final Builder expandWildcards(ExpandWildcard value, ExpandWildcard ... values) {
            this.expandWildcards = Builder._listAdd(this.expandWildcards, value, values);
            return this;
        }

        public final Builder explain(@Nullable Boolean value) {
            this.explain = value;
            return this;
        }

        public final Builder id(@Nullable String value) {
            this.id = value;
            return this;
        }

        public final Builder ignoreThrottled(@Nullable Boolean value) {
            this.ignoreThrottled = value;
            return this;
        }

        public final Builder ignoreUnavailable(@Nullable Boolean value) {
            this.ignoreUnavailable = value;
            return this;
        }

        public final Builder index(List<String> list) {
            this.index = Builder._listAddAll(this.index, list);
            return this;
        }

        public final Builder index(String value, String ... values) {
            this.index = Builder._listAdd(this.index, value, values);
            return this;
        }

        public final Builder params(Map<String, JsonData> map) {
            this.params = Builder._mapPutAll(this.params, map);
            return this;
        }

        public final Builder params(String key, JsonData value) {
            this.params = Builder._mapPut(this.params, key, value);
            return this;
        }

        public final Builder preference(@Nullable String value) {
            this.preference = value;
            return this;
        }

        public final Builder profile(@Nullable Boolean value) {
            this.profile = value;
            return this;
        }

        public final Builder routing(@Nullable String value) {
            this.routing = value;
            return this;
        }

        public final Builder scroll(@Nullable Time value) {
            this.scroll = value;
            return this;
        }

        public final Builder scroll(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.scroll(fn.apply(new Time.Builder()).build());
        }

        public final Builder searchType(@Nullable SearchType value) {
            this.searchType = value;
            return this;
        }

        public final Builder source(@Nullable String value) {
            this.source = value;
            return this;
        }

        @Override
        public SearchTemplateRequest build() {
            this._checkSingleUse();
            return new SearchTemplateRequest(this);
        }
    }
}

