/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.mapping;

import co.elastic.clients.elasticsearch._types.mapping.DocValuesPropertyBase;
import co.elastic.clients.elasticsearch._types.mapping.TimeSeriesMetricType;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectDeserializer;
import jakarta.json.stream.JsonGenerator;
import javax.annotation.Nullable;

public abstract class NumberPropertyBase
extends DocValuesPropertyBase {
    @Nullable
    private final Boolean index;
    @Nullable
    private final Boolean ignoreMalformed;
    @Nullable
    private final TimeSeriesMetricType timeSeriesMetric;

    protected NumberPropertyBase(AbstractBuilder<?> builder) {
        super((DocValuesPropertyBase.AbstractBuilder<?>)builder);
        this.index = ((AbstractBuilder)builder).index;
        this.ignoreMalformed = ((AbstractBuilder)builder).ignoreMalformed;
        this.timeSeriesMetric = ((AbstractBuilder)builder).timeSeriesMetric;
    }

    @Nullable
    public final Boolean index() {
        return this.index;
    }

    @Nullable
    public final Boolean ignoreMalformed() {
        return this.ignoreMalformed;
    }

    @Nullable
    public final TimeSeriesMetricType timeSeriesMetric() {
        return this.timeSeriesMetric;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        if (this.index != null) {
            generator.writeKey("index");
            generator.write(this.index.booleanValue());
        }
        if (this.ignoreMalformed != null) {
            generator.writeKey("ignore_malformed");
            generator.write(this.ignoreMalformed.booleanValue());
        }
        if (this.timeSeriesMetric != null) {
            generator.writeKey("time_series_metric");
            this.timeSeriesMetric.serialize(generator, mapper);
        }
    }

    protected static <BuilderT extends AbstractBuilder<BuilderT>> void setupNumberPropertyBaseDeserializer(ObjectDeserializer<BuilderT> op) {
        DocValuesPropertyBase.setupDocValuesPropertyBaseDeserializer(op);
        op.add(AbstractBuilder::index, JsonpDeserializer.booleanDeserializer(), "index");
        op.add(AbstractBuilder::ignoreMalformed, JsonpDeserializer.booleanDeserializer(), "ignore_malformed");
        op.add(AbstractBuilder::timeSeriesMetric, TimeSeriesMetricType._DESERIALIZER, "time_series_metric");
    }

    protected static abstract class AbstractBuilder<BuilderT extends AbstractBuilder<BuilderT>>
    extends DocValuesPropertyBase.AbstractBuilder<BuilderT> {
        @Nullable
        private Boolean index;
        @Nullable
        private Boolean ignoreMalformed;
        @Nullable
        private TimeSeriesMetricType timeSeriesMetric;

        protected AbstractBuilder() {
        }

        public final BuilderT index(@Nullable Boolean value) {
            this.index = value;
            return (BuilderT)((AbstractBuilder)this.self());
        }

        public final BuilderT ignoreMalformed(@Nullable Boolean value) {
            this.ignoreMalformed = value;
            return (BuilderT)((AbstractBuilder)this.self());
        }

        public final BuilderT timeSeriesMetric(@Nullable TimeSeriesMetricType value) {
            this.timeSeriesMetric = value;
            return (BuilderT)((AbstractBuilder)this.self());
        }
    }
}

