/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.aggregations;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.ObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class StandardDeviationBoundsAsString
implements JsonpSerializable {
    private final String upper;
    private final String lower;
    private final String upperPopulation;
    private final String lowerPopulation;
    private final String upperSampling;
    private final String lowerSampling;
    public static final JsonpDeserializer<StandardDeviationBoundsAsString> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, StandardDeviationBoundsAsString::setupStandardDeviationBoundsAsStringDeserializer);

    private StandardDeviationBoundsAsString(Builder builder) {
        this.upper = ApiTypeHelper.requireNonNull(builder.upper, this, "upper");
        this.lower = ApiTypeHelper.requireNonNull(builder.lower, this, "lower");
        this.upperPopulation = ApiTypeHelper.requireNonNull(builder.upperPopulation, this, "upperPopulation");
        this.lowerPopulation = ApiTypeHelper.requireNonNull(builder.lowerPopulation, this, "lowerPopulation");
        this.upperSampling = ApiTypeHelper.requireNonNull(builder.upperSampling, this, "upperSampling");
        this.lowerSampling = ApiTypeHelper.requireNonNull(builder.lowerSampling, this, "lowerSampling");
    }

    public static StandardDeviationBoundsAsString of(Function<Builder, ObjectBuilder<StandardDeviationBoundsAsString>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String upper() {
        return this.upper;
    }

    public final String lower() {
        return this.lower;
    }

    public final String upperPopulation() {
        return this.upperPopulation;
    }

    public final String lowerPopulation() {
        return this.lowerPopulation;
    }

    public final String upperSampling() {
        return this.upperSampling;
    }

    public final String lowerSampling() {
        return this.lowerSampling;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("upper");
        generator.write(this.upper);
        generator.writeKey("lower");
        generator.write(this.lower);
        generator.writeKey("upper_population");
        generator.write(this.upperPopulation);
        generator.writeKey("lower_population");
        generator.write(this.lowerPopulation);
        generator.writeKey("upper_sampling");
        generator.write(this.upperSampling);
        generator.writeKey("lower_sampling");
        generator.write(this.lowerSampling);
    }

    protected static void setupStandardDeviationBoundsAsStringDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::upper, JsonpDeserializer.stringDeserializer(), "upper");
        op.add(Builder::lower, JsonpDeserializer.stringDeserializer(), "lower");
        op.add(Builder::upperPopulation, JsonpDeserializer.stringDeserializer(), "upper_population");
        op.add(Builder::lowerPopulation, JsonpDeserializer.stringDeserializer(), "lower_population");
        op.add(Builder::upperSampling, JsonpDeserializer.stringDeserializer(), "upper_sampling");
        op.add(Builder::lowerSampling, JsonpDeserializer.stringDeserializer(), "lower_sampling");
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<StandardDeviationBoundsAsString> {
        private String upper;
        private String lower;
        private String upperPopulation;
        private String lowerPopulation;
        private String upperSampling;
        private String lowerSampling;

        public final Builder upper(String value) {
            this.upper = value;
            return this;
        }

        public final Builder lower(String value) {
            this.lower = value;
            return this;
        }

        public final Builder upperPopulation(String value) {
            this.upperPopulation = value;
            return this;
        }

        public final Builder lowerPopulation(String value) {
            this.lowerPopulation = value;
            return this;
        }

        public final Builder upperSampling(String value) {
            this.upperSampling = value;
            return this;
        }

        public final Builder lowerSampling(String value) {
            this.lowerSampling = value;
            return this;
        }

        @Override
        public StandardDeviationBoundsAsString build() {
            this._checkSingleUse();
            return new StandardDeviationBoundsAsString(this);
        }
    }
}

