/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.analysis;

import co.elastic.clients.elasticsearch._types.analysis.Analyzer;
import co.elastic.clients.elasticsearch._types.analysis.AnalyzerVariant;
import co.elastic.clients.elasticsearch._types.analysis.SnowballLanguage;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.ObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class SnowballAnalyzer
implements AnalyzerVariant,
JsonpSerializable {
    @Nullable
    private final String version;
    private final SnowballLanguage language;
    private final List<String> stopwords;
    public static final JsonpDeserializer<SnowballAnalyzer> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, SnowballAnalyzer::setupSnowballAnalyzerDeserializer);

    private SnowballAnalyzer(Builder builder) {
        this.version = builder.version;
        this.language = ApiTypeHelper.requireNonNull(builder.language, this, "language");
        this.stopwords = ApiTypeHelper.unmodifiable(builder.stopwords);
    }

    public static SnowballAnalyzer of(Function<Builder, ObjectBuilder<SnowballAnalyzer>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Analyzer.Kind _analyzerKind() {
        return Analyzer.Kind.Snowball;
    }

    @Nullable
    public final String version() {
        return this.version;
    }

    public final SnowballLanguage language() {
        return this.language;
    }

    public final List<String> stopwords() {
        return this.stopwords;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.write("type", "snowball");
        if (this.version != null) {
            generator.writeKey("version");
            generator.write(this.version);
        }
        generator.writeKey("language");
        this.language.serialize(generator, mapper);
        if (ApiTypeHelper.isDefined(this.stopwords)) {
            generator.writeKey("stopwords");
            generator.writeStartArray();
            for (String item0 : this.stopwords) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
    }

    protected static void setupSnowballAnalyzerDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::version, JsonpDeserializer.stringDeserializer(), "version");
        op.add(Builder::language, SnowballLanguage._DESERIALIZER, "language");
        op.add(Builder::stopwords, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "stopwords");
        op.ignore("type");
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<SnowballAnalyzer> {
        @Nullable
        private String version;
        private SnowballLanguage language;
        @Nullable
        private List<String> stopwords;

        public final Builder version(@Nullable String value) {
            this.version = value;
            return this;
        }

        public final Builder language(SnowballLanguage value) {
            this.language = value;
            return this;
        }

        public final Builder stopwords(List<String> list) {
            this.stopwords = Builder._listAddAll(this.stopwords, list);
            return this;
        }

        public final Builder stopwords(String value, String ... values) {
            this.stopwords = Builder._listAdd(this.stopwords, value, values);
            return this;
        }

        @Override
        public SnowballAnalyzer build() {
            this._checkSingleUse();
            return new SnowballAnalyzer(this);
        }
    }
}

