/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.transport;

import co.elastic.clients.ApiClient;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.transport.Transport;
import co.elastic.clients.transport.endpoints.BinaryEndpoint;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;

public interface Endpoint<RequestT, ResponseT, ErrorT> {
    public String id();

    public String method(RequestT var1);

    public String requestUrl(RequestT var1);

    default public Map<String, String> queryParameters(RequestT request) {
        return Collections.emptyMap();
    }

    default public Map<String, String> headers(RequestT request) {
        return Collections.emptyMap();
    }

    @Nullable
    public Object body(RequestT var1);

    public boolean isError(int var1);

    @Nullable
    public JsonpDeserializer<ErrorT> errorDeserializer(int var1);

    default public BinaryEndpoint<RequestT> withBinaryResponse() {
        return new BinaryEndpoint<Object>(this.id(), this::method, this::requestUrl, this::queryParameters, this::headers, this::body, null);
    }

    default public ResponseT call(RequestT request, Transport transport) throws IOException {
        return transport.performRequest(request, this, null);
    }

    default public ResponseT call(RequestT request, ApiClient<?, ?> client) throws IOException {
        return client._transport().performRequest(request, this, null);
    }

    default public CompletableFuture<ResponseT> callAsync(RequestT request, Transport transport) throws IOException {
        return transport.performRequestAsync(request, this, null);
    }

    default public CompletableFuture<ResponseT> callAsync(RequestT request, ApiClient<?, ?> client) throws IOException {
        return client._transport().performRequestAsync(request, this, null);
    }
}

