/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.aggregations;

import co.elastic.clients.elasticsearch._types.Time;
import co.elastic.clients.elasticsearch._types.aggregations.CompositeAggregationBase;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class CompositeDateHistogramAggregation
extends CompositeAggregationBase {
    @Nullable
    private final String format;
    @Nullable
    private final String calendarInterval;
    @Nullable
    private final String fixedInterval;
    @Nullable
    private final Time offset;
    @Nullable
    private final String timeZone;
    public static final JsonpDeserializer<CompositeDateHistogramAggregation> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, CompositeDateHistogramAggregation::setupCompositeDateHistogramAggregationDeserializer);

    private CompositeDateHistogramAggregation(Builder builder) {
        super(builder);
        this.format = builder.format;
        this.calendarInterval = builder.calendarInterval;
        this.fixedInterval = builder.fixedInterval;
        this.offset = builder.offset;
        this.timeZone = builder.timeZone;
    }

    public static CompositeDateHistogramAggregation of(Function<Builder, ObjectBuilder<CompositeDateHistogramAggregation>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final String format() {
        return this.format;
    }

    @Nullable
    public final String calendarInterval() {
        return this.calendarInterval;
    }

    @Nullable
    public final String fixedInterval() {
        return this.fixedInterval;
    }

    @Nullable
    public final Time offset() {
        return this.offset;
    }

    @Nullable
    public final String timeZone() {
        return this.timeZone;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        if (this.format != null) {
            generator.writeKey("format");
            generator.write(this.format);
        }
        if (this.calendarInterval != null) {
            generator.writeKey("calendar_interval");
            generator.write(this.calendarInterval);
        }
        if (this.fixedInterval != null) {
            generator.writeKey("fixed_interval");
            generator.write(this.fixedInterval);
        }
        if (this.offset != null) {
            generator.writeKey("offset");
            this.offset.serialize(generator, mapper);
        }
        if (this.timeZone != null) {
            generator.writeKey("time_zone");
            generator.write(this.timeZone);
        }
    }

    protected static void setupCompositeDateHistogramAggregationDeserializer(ObjectDeserializer<Builder> op) {
        CompositeAggregationBase.setupCompositeAggregationBaseDeserializer(op);
        op.add(Builder::format, JsonpDeserializer.stringDeserializer(), "format");
        op.add(Builder::calendarInterval, JsonpDeserializer.stringDeserializer(), "calendar_interval");
        op.add(Builder::fixedInterval, JsonpDeserializer.stringDeserializer(), "fixed_interval");
        op.add(Builder::offset, Time._DESERIALIZER, "offset");
        op.add(Builder::timeZone, JsonpDeserializer.stringDeserializer(), "time_zone");
    }

    public static class Builder
    extends CompositeAggregationBase.AbstractBuilder<Builder>
    implements ObjectBuilder<CompositeDateHistogramAggregation> {
        @Nullable
        private String format;
        @Nullable
        private String calendarInterval;
        @Nullable
        private String fixedInterval;
        @Nullable
        private Time offset;
        @Nullable
        private String timeZone;

        public final Builder format(@Nullable String value) {
            this.format = value;
            return this;
        }

        public final Builder calendarInterval(@Nullable String value) {
            this.calendarInterval = value;
            return this;
        }

        public final Builder fixedInterval(@Nullable String value) {
            this.fixedInterval = value;
            return this;
        }

        public final Builder offset(@Nullable Time value) {
            this.offset = value;
            return this;
        }

        public final Builder offset(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.offset(fn.apply(new Time.Builder()).build());
        }

        public final Builder timeZone(@Nullable String value) {
            this.timeZone = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public CompositeDateHistogramAggregation build() {
            this._checkSingleUse();
            return new CompositeDateHistogramAggregation(this);
        }
    }
}

