/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.nodes;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class PressureMemory
implements JsonpSerializable {
    @Nullable
    private final Long combinedCoordinatingAndPrimaryInBytes;
    @Nullable
    private final Long coordinatingInBytes;
    @Nullable
    private final Long primaryInBytes;
    @Nullable
    private final Long replicaInBytes;
    @Nullable
    private final Long allInBytes;
    @Nullable
    private final Long coordinatingRejections;
    @Nullable
    private final Long primaryRejections;
    @Nullable
    private final Long replicaRejections;
    public static final JsonpDeserializer<PressureMemory> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, PressureMemory::setupPressureMemoryDeserializer);

    private PressureMemory(Builder builder) {
        this.combinedCoordinatingAndPrimaryInBytes = builder.combinedCoordinatingAndPrimaryInBytes;
        this.coordinatingInBytes = builder.coordinatingInBytes;
        this.primaryInBytes = builder.primaryInBytes;
        this.replicaInBytes = builder.replicaInBytes;
        this.allInBytes = builder.allInBytes;
        this.coordinatingRejections = builder.coordinatingRejections;
        this.primaryRejections = builder.primaryRejections;
        this.replicaRejections = builder.replicaRejections;
    }

    public static PressureMemory of(Function<Builder, ObjectBuilder<PressureMemory>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Long combinedCoordinatingAndPrimaryInBytes() {
        return this.combinedCoordinatingAndPrimaryInBytes;
    }

    @Nullable
    public final Long coordinatingInBytes() {
        return this.coordinatingInBytes;
    }

    @Nullable
    public final Long primaryInBytes() {
        return this.primaryInBytes;
    }

    @Nullable
    public final Long replicaInBytes() {
        return this.replicaInBytes;
    }

    @Nullable
    public final Long allInBytes() {
        return this.allInBytes;
    }

    @Nullable
    public final Long coordinatingRejections() {
        return this.coordinatingRejections;
    }

    @Nullable
    public final Long primaryRejections() {
        return this.primaryRejections;
    }

    @Nullable
    public final Long replicaRejections() {
        return this.replicaRejections;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.combinedCoordinatingAndPrimaryInBytes != null) {
            generator.writeKey("combined_coordinating_and_primary_in_bytes");
            generator.write(this.combinedCoordinatingAndPrimaryInBytes.longValue());
        }
        if (this.coordinatingInBytes != null) {
            generator.writeKey("coordinating_in_bytes");
            generator.write(this.coordinatingInBytes.longValue());
        }
        if (this.primaryInBytes != null) {
            generator.writeKey("primary_in_bytes");
            generator.write(this.primaryInBytes.longValue());
        }
        if (this.replicaInBytes != null) {
            generator.writeKey("replica_in_bytes");
            generator.write(this.replicaInBytes.longValue());
        }
        if (this.allInBytes != null) {
            generator.writeKey("all_in_bytes");
            generator.write(this.allInBytes.longValue());
        }
        if (this.coordinatingRejections != null) {
            generator.writeKey("coordinating_rejections");
            generator.write(this.coordinatingRejections.longValue());
        }
        if (this.primaryRejections != null) {
            generator.writeKey("primary_rejections");
            generator.write(this.primaryRejections.longValue());
        }
        if (this.replicaRejections != null) {
            generator.writeKey("replica_rejections");
            generator.write(this.replicaRejections.longValue());
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupPressureMemoryDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::combinedCoordinatingAndPrimaryInBytes, JsonpDeserializer.longDeserializer(), "combined_coordinating_and_primary_in_bytes");
        op.add(Builder::coordinatingInBytes, JsonpDeserializer.longDeserializer(), "coordinating_in_bytes");
        op.add(Builder::primaryInBytes, JsonpDeserializer.longDeserializer(), "primary_in_bytes");
        op.add(Builder::replicaInBytes, JsonpDeserializer.longDeserializer(), "replica_in_bytes");
        op.add(Builder::allInBytes, JsonpDeserializer.longDeserializer(), "all_in_bytes");
        op.add(Builder::coordinatingRejections, JsonpDeserializer.longDeserializer(), "coordinating_rejections");
        op.add(Builder::primaryRejections, JsonpDeserializer.longDeserializer(), "primary_rejections");
        op.add(Builder::replicaRejections, JsonpDeserializer.longDeserializer(), "replica_rejections");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<PressureMemory> {
        @Nullable
        private Long combinedCoordinatingAndPrimaryInBytes;
        @Nullable
        private Long coordinatingInBytes;
        @Nullable
        private Long primaryInBytes;
        @Nullable
        private Long replicaInBytes;
        @Nullable
        private Long allInBytes;
        @Nullable
        private Long coordinatingRejections;
        @Nullable
        private Long primaryRejections;
        @Nullable
        private Long replicaRejections;

        public final Builder combinedCoordinatingAndPrimaryInBytes(@Nullable Long value) {
            this.combinedCoordinatingAndPrimaryInBytes = value;
            return this;
        }

        public final Builder coordinatingInBytes(@Nullable Long value) {
            this.coordinatingInBytes = value;
            return this;
        }

        public final Builder primaryInBytes(@Nullable Long value) {
            this.primaryInBytes = value;
            return this;
        }

        public final Builder replicaInBytes(@Nullable Long value) {
            this.replicaInBytes = value;
            return this;
        }

        public final Builder allInBytes(@Nullable Long value) {
            this.allInBytes = value;
            return this;
        }

        public final Builder coordinatingRejections(@Nullable Long value) {
            this.coordinatingRejections = value;
            return this;
        }

        public final Builder primaryRejections(@Nullable Long value) {
            this.primaryRejections = value;
            return this;
        }

        public final Builder replicaRejections(@Nullable Long value) {
            this.replicaRejections = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public PressureMemory build() {
            this._checkSingleUse();
            return new PressureMemory(this);
        }
    }
}

