/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.core;

import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch._types.Refresh;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch._types.Time;
import co.elastic.clients.elasticsearch._types.VersionType;
import co.elastic.clients.elasticsearch._types.WaitForActiveShards;
import co.elastic.clients.elasticsearch.core.DeleteResponse;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import java.util.HashMap;
import java.util.function.Function;
import javax.annotation.Nullable;

public class DeleteRequest
extends RequestBase {
    private final String id;
    @Nullable
    private final Long ifPrimaryTerm;
    @Nullable
    private final Long ifSeqNo;
    private final String index;
    @Nullable
    private final Refresh refresh;
    @Nullable
    private final String routing;
    @Nullable
    private final Time timeout;
    @Nullable
    private final String type;
    @Nullable
    private final Long version;
    @Nullable
    private final VersionType versionType;
    @Nullable
    private final WaitForActiveShards waitForActiveShards;
    public static final Endpoint<DeleteRequest, DeleteResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<DeleteRequest, DeleteResponse>("es/delete", request -> "DELETE", request -> {
        boolean _index = true;
        int _id = 2;
        int _type = 4;
        int propsSet = 0;
        propsSet |= 1;
        propsSet |= 2;
        if (request.type() != null) {
            propsSet |= 4;
        }
        if (propsSet == 3) {
            StringBuilder buf = new StringBuilder();
            buf.append("/");
            SimpleEndpoint.pathEncode(request.index, buf);
            buf.append("/_doc");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.id, buf);
            return buf.toString();
        }
        if (propsSet == 7) {
            StringBuilder buf = new StringBuilder();
            buf.append("/");
            SimpleEndpoint.pathEncode(request.index, buf);
            buf.append("/");
            SimpleEndpoint.pathEncode(request.type, buf);
            buf.append("/");
            SimpleEndpoint.pathEncode(request.id, buf);
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.routing != null) {
            params.put("routing", request.routing);
        }
        if (request.versionType != null) {
            params.put("version_type", request.versionType.jsonValue());
        }
        if (request.ifPrimaryTerm != null) {
            params.put("if_primary_term", String.valueOf(request.ifPrimaryTerm));
        }
        if (request.ifSeqNo != null) {
            params.put("if_seq_no", String.valueOf(request.ifSeqNo));
        }
        if (request.refresh != null) {
            params.put("refresh", request.refresh.jsonValue());
        }
        if (request.waitForActiveShards != null) {
            params.put("wait_for_active_shards", request.waitForActiveShards._toJsonString());
        }
        if (request.version != null) {
            params.put("version", String.valueOf(request.version));
        }
        if (request.timeout != null) {
            params.put("timeout", request.timeout._toJsonString());
        }
        return params;
    }, SimpleEndpoint.emptyMap(), false, DeleteResponse._DESERIALIZER);

    private DeleteRequest(Builder builder) {
        this.id = ApiTypeHelper.requireNonNull(builder.id, this, "id");
        this.ifPrimaryTerm = builder.ifPrimaryTerm;
        this.ifSeqNo = builder.ifSeqNo;
        this.index = ApiTypeHelper.requireNonNull(builder.index, this, "index");
        this.refresh = builder.refresh;
        this.routing = builder.routing;
        this.timeout = builder.timeout;
        this.type = builder.type;
        this.version = builder.version;
        this.versionType = builder.versionType;
        this.waitForActiveShards = builder.waitForActiveShards;
    }

    public static DeleteRequest of(Function<Builder, ObjectBuilder<DeleteRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String id() {
        return this.id;
    }

    @Nullable
    public final Long ifPrimaryTerm() {
        return this.ifPrimaryTerm;
    }

    @Nullable
    public final Long ifSeqNo() {
        return this.ifSeqNo;
    }

    public final String index() {
        return this.index;
    }

    @Nullable
    public final Refresh refresh() {
        return this.refresh;
    }

    @Nullable
    public final String routing() {
        return this.routing;
    }

    @Nullable
    public final Time timeout() {
        return this.timeout;
    }

    @Nullable
    public final String type() {
        return this.type;
    }

    @Nullable
    public final Long version() {
        return this.version;
    }

    @Nullable
    public final VersionType versionType() {
        return this.versionType;
    }

    @Nullable
    public final WaitForActiveShards waitForActiveShards() {
        return this.waitForActiveShards;
    }

    public static class Builder
    extends RequestBase.AbstractBuilder<Builder>
    implements ObjectBuilder<DeleteRequest> {
        private String id;
        @Nullable
        private Long ifPrimaryTerm;
        @Nullable
        private Long ifSeqNo;
        private String index;
        @Nullable
        private Refresh refresh;
        @Nullable
        private String routing;
        @Nullable
        private Time timeout;
        @Nullable
        private String type;
        @Nullable
        private Long version;
        @Nullable
        private VersionType versionType;
        @Nullable
        private WaitForActiveShards waitForActiveShards;

        public final Builder id(String value) {
            this.id = value;
            return this;
        }

        public final Builder ifPrimaryTerm(@Nullable Long value) {
            this.ifPrimaryTerm = value;
            return this;
        }

        public final Builder ifSeqNo(@Nullable Long value) {
            this.ifSeqNo = value;
            return this;
        }

        public final Builder index(String value) {
            this.index = value;
            return this;
        }

        public final Builder refresh(@Nullable Refresh value) {
            this.refresh = value;
            return this;
        }

        public final Builder routing(@Nullable String value) {
            this.routing = value;
            return this;
        }

        public final Builder timeout(@Nullable Time value) {
            this.timeout = value;
            return this;
        }

        public final Builder timeout(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.timeout(fn.apply(new Time.Builder()).build());
        }

        public final Builder type(@Nullable String value) {
            this.type = value;
            return this;
        }

        public final Builder version(@Nullable Long value) {
            this.version = value;
            return this;
        }

        public final Builder versionType(@Nullable VersionType value) {
            this.versionType = value;
            return this;
        }

        public final Builder waitForActiveShards(@Nullable WaitForActiveShards value) {
            this.waitForActiveShards = value;
            return this;
        }

        public final Builder waitForActiveShards(Function<WaitForActiveShards.Builder, ObjectBuilder<WaitForActiveShards>> fn) {
            return this.waitForActiveShards(fn.apply(new WaitForActiveShards.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public DeleteRequest build() {
            this._checkSingleUse();
            return new DeleteRequest(this);
        }
    }
}

