/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._helpers.bulk;

import co.elastic.clients.elasticsearch.ElasticsearchAsyncClient;
import co.elastic.clients.elasticsearch.ElasticsearchClient;
import co.elastic.clients.elasticsearch._helpers.bulk.BulkListener;
import co.elastic.clients.elasticsearch._helpers.bulk.FnCondition;
import co.elastic.clients.elasticsearch._helpers.bulk.IngesterOperation;
import co.elastic.clients.elasticsearch.core.BulkRequest;
import co.elastic.clients.elasticsearch.core.BulkResponse;
import co.elastic.clients.elasticsearch.core.bulk.BulkOperation;
import co.elastic.clients.transport.ElasticsearchTransport;
import co.elastic.clients.transport.TransportOptions;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BulkIngester<Context>
implements AutoCloseable {
    private static final Log logger = LogFactory.getLog(BulkIngester.class);
    private static final AtomicInteger idCounter = new AtomicInteger();
    private final ElasticsearchAsyncClient client;
    @Nullable
    private final BulkRequest globalSettings;
    private final int maxRequests;
    private final long maxSize;
    private final int maxOperations;
    @Nullable
    private final BulkListener<Context> listener;
    private final Long flushIntervalMillis;
    @Nullable
    private ScheduledFuture<?> flushTask;
    @Nullable
    private ScheduledExecutorService scheduler;
    private List<BulkOperation> operations = new ArrayList<BulkOperation>();
    private List<Context> contexts = null;
    private long currentSize;
    private int requestsInFlightCount;
    private volatile boolean isClosed = false;
    private final ReentrantLock lock = new ReentrantLock();
    private final FnCondition addCondition = new FnCondition(this.lock, this::canAddOperation);
    private final FnCondition sendRequestCondition = new FnCondition(this.lock, this::canSendRequest);
    private final FnCondition closeCondition = new FnCondition(this.lock, this::closedAndFlushed);

    private BulkIngester(Builder<Context> builder) {
        int ingesterId = idCounter.incrementAndGet();
        this.client = ApiTypeHelper.requireNonNull(((Builder)builder).client, this, "client");
        this.globalSettings = ((Builder)builder).globalSettings;
        this.maxRequests = ((Builder)builder).maxConcurrentRequests;
        this.maxSize = ((Builder)builder).bulkSize < 0L ? Long.MAX_VALUE : ((Builder)builder).bulkSize;
        this.maxOperations = ((Builder)builder).bulkOperations < 0 ? Integer.MAX_VALUE : ((Builder)builder).bulkOperations;
        this.listener = ((Builder)builder).listener;
        this.flushIntervalMillis = ((Builder)builder).flushIntervalMillis;
        if (this.flushIntervalMillis != null) {
            ScheduledExecutorService scheduler;
            long flushInterval = this.flushIntervalMillis;
            if (((Builder)builder).scheduler == null) {
                this.scheduler = scheduler = Executors.newSingleThreadScheduledExecutor(r -> {
                    Thread t = Executors.defaultThreadFactory().newThread(r);
                    t.setName("bulk-ingester-flusher#" + ingesterId);
                    t.setDaemon(true);
                    return t;
                });
            } else {
                scheduler = ((Builder)builder).scheduler;
            }
            this.flushTask = scheduler.scheduleWithFixedDelay(this::failsafeFlush, flushInterval, flushInterval, TimeUnit.MILLISECONDS);
        }
    }

    public int maxOperations() {
        return this.maxOperations;
    }

    public long maxSize() {
        return this.maxSize;
    }

    public int maxConcurrentRequests() {
        return this.maxRequests;
    }

    public Duration flushInterval() {
        if (this.flushIntervalMillis != null) {
            return Duration.ofMillis(this.flushIntervalMillis);
        }
        return null;
    }

    public int pendingOperations() {
        List<BulkOperation> operations = this.operations;
        return operations == null ? 0 : operations.size();
    }

    public long pendingOperationsSize() {
        return this.currentSize;
    }

    public int pendingRequests() {
        return this.requestsInFlightCount;
    }

    public long operationsCount() {
        return this.addCondition.invocations();
    }

    public long operationContentionsCount() {
        return this.addCondition.contentions();
    }

    public long requestCount() {
        return this.sendRequestCondition.invocations();
    }

    public long requestContentionsCount() {
        return this.sendRequestCondition.contentions();
    }

    private boolean canSendRequest() {
        return this.requestsInFlightCount < this.maxRequests;
    }

    private boolean canAddOperation() {
        return this.currentSize < this.maxSize && this.operations.size() < this.maxOperations;
    }

    private boolean closedAndFlushed() {
        return this.isClosed && this.operations.isEmpty() && this.requestsInFlightCount == 0;
    }

    private BulkRequest.Builder newRequest() {
        BulkRequest.Builder result = new BulkRequest.Builder();
        if (this.globalSettings != null) {
            BulkRequest settings = this.globalSettings;
            result.index(settings.index()).pipeline(settings.pipeline()).refresh(settings.refresh()).requireAlias(settings.requireAlias()).routing(settings.routing()).sourceExcludes(settings.sourceExcludes()).sourceIncludes(settings.sourceIncludes()).source(settings.source()).timeout(settings.timeout()).waitForActiveShards(settings.waitForActiveShards());
        }
        return result;
    }

    private void failsafeFlush() {
        try {
            this.flush();
        }
        catch (Throwable thr) {
            logger.error((Object)"Error in background flush", thr);
        }
    }

    public void flush() {
        RequestExecution exec = this.sendRequestCondition.whenReadyIf(() -> !this.operations.isEmpty(), () -> {
            BulkRequest request = this.newRequest().operations(this.operations).build();
            List<Context> requestContexts = this.contexts == null ? Collections.nCopies(this.operations.size(), null) : this.contexts;
            this.operations = new ArrayList<BulkOperation>();
            this.contexts = null;
            this.currentSize = 0L;
            this.addCondition.signalIfReady();
            long id = this.sendRequestCondition.invocations();
            if (this.listener != null) {
                this.listener.beforeBulk(id, request, requestContexts);
            }
            CompletableFuture<BulkResponse> result = this.client.bulk(request);
            ++this.requestsInFlightCount;
            if (this.listener == null) {
                request = null;
            }
            return new RequestExecution<Context>(id, request, requestContexts, result);
        });
        if (exec != null) {
            exec.futureResponse.handle((resp, thr) -> {
                this.sendRequestCondition.signalIfReadyAfter(() -> {
                    --this.requestsInFlightCount;
                    this.closeCondition.signalAllIfReady();
                });
                if (resp != null) {
                    if (this.listener != null) {
                        this.listener.afterBulk(exec.id, exec.request, exec.contexts, (BulkResponse)resp);
                    }
                } else if (this.listener != null) {
                    this.listener.afterBulk(exec.id, exec.request, exec.contexts, (Throwable)thr);
                }
                return null;
            });
        }
    }

    public void add(BulkOperation operation, Context context) {
        if (this.isClosed) {
            throw new IllegalStateException("Ingester has been closed");
        }
        IngesterOperation ingestOp = IngesterOperation.of(operation, this.client._jsonpMapper());
        this.addCondition.whenReady(() -> {
            if (context != null) {
                if (this.contexts == null) {
                    int size = this.operations.size();
                    this.contexts = size == 0 ? new ArrayList<Context>() : new ArrayList<Object>(Collections.nCopies(size, null));
                }
                this.contexts.add(context);
            }
            this.operations.add(ingestOp.operation());
            this.currentSize += ingestOp.size();
            if (!this.canAddOperation()) {
                this.flush();
            } else {
                this.addCondition.signalIfReady();
            }
        });
    }

    public void add(BulkOperation operation) {
        this.add(operation, null);
    }

    public void add(Function<BulkOperation.Builder, ObjectBuilder<BulkOperation>> f) {
        this.add(f.apply(new BulkOperation.Builder()).build(), null);
    }

    public void add(Function<BulkOperation.Builder, ObjectBuilder<BulkOperation>> f, Context context) {
        this.add(f.apply(new BulkOperation.Builder()).build(), context);
    }

    @Override
    public void close() {
        if (this.isClosed) {
            return;
        }
        this.isClosed = true;
        this.flush();
        this.closeCondition.whenReady(() -> {});
        if (this.flushTask != null) {
            this.flushTask.cancel(false);
        }
        if (this.scheduler != null) {
            this.scheduler.shutdownNow();
        }
    }

    public static <Context> BulkIngester<Context> of(Function<Builder<Context>, Builder<Context>> f) {
        return f.apply(new Builder()).build();
    }

    public static class Builder<Context>
    implements ObjectBuilder<BulkIngester<Context>> {
        private ElasticsearchAsyncClient client;
        private BulkRequest globalSettings;
        private int bulkOperations = 1000;
        private long bulkSize = 0x500000L;
        private int maxConcurrentRequests = 1;
        private Long flushIntervalMillis;
        private BulkListener<Context> listener;
        private ScheduledExecutorService scheduler;

        public Builder<Context> client(ElasticsearchAsyncClient client) {
            this.client = client;
            return this;
        }

        public Builder<Context> client(ElasticsearchClient client) {
            TransportOptions options = client._transportOptions();
            if (options == ((ElasticsearchTransport)client._transport()).options()) {
                options = null;
            }
            return this.client(new ElasticsearchAsyncClient((ElasticsearchTransport)client._transport(), options));
        }

        public Builder<Context> maxOperations(int count) {
            if (count < -1) {
                throw new IllegalArgumentException("Max operations should be at least -1");
            }
            this.bulkOperations = count;
            return this;
        }

        public Builder<Context> maxSize(long bytes) {
            if (bytes < -1L) {
                throw new IllegalArgumentException("Max size should be at least -1");
            }
            this.bulkSize = bytes;
            return this;
        }

        public Builder<Context> maxConcurrentRequests(int max) {
            if (max < 1) {
                throw new IllegalArgumentException("Max concurrent request should be at least 1");
            }
            this.maxConcurrentRequests = max;
            return this;
        }

        public Builder<Context> flushInterval(long value, TimeUnit unit) {
            if (value < 0L) {
                throw new IllegalArgumentException("Duration should be positive");
            }
            this.flushIntervalMillis = unit.toMillis(value);
            return this;
        }

        public Builder<Context> flushInterval(long value, TimeUnit unit, ScheduledExecutorService scheduler) {
            this.scheduler = scheduler;
            return this.flushInterval(value, unit);
        }

        public Builder<Context> listener(BulkListener<Context> listener) {
            this.listener = listener;
            return this;
        }

        public Builder<Context> globalSettings(BulkRequest.Builder settings) {
            this.globalSettings = settings != null ? settings.operations(Collections.emptyList()).build() : null;
            return this;
        }

        public Builder<Context> globalSettings(Function<BulkRequest.Builder, BulkRequest.Builder> fn) {
            return this.globalSettings(fn.apply(new BulkRequest.Builder()));
        }

        @Override
        public BulkIngester<Context> build() {
            boolean hasCriteria;
            boolean bl = hasCriteria = this.bulkOperations >= 0 || this.bulkSize >= 0L || this.flushIntervalMillis != null;
            if (!hasCriteria) {
                throw new IllegalStateException("No bulk operation chunking criteria have been set.");
            }
            return new BulkIngester(this);
        }
    }

    private static class RequestExecution<Context> {
        public final long id;
        public final BulkRequest request;
        public final List<Context> contexts;
        public final CompletionStage<BulkResponse> futureResponse;

        RequestExecution(long id, BulkRequest request, List<Context> contexts, CompletionStage<BulkResponse> futureResponse) {
            this.id = id;
            this.request = request;
            this.contexts = contexts;
            this.futureResponse = futureResponse;
        }
    }
}

