/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ingest;

import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch._types.Time;
import co.elastic.clients.elasticsearch.ingest.GetPipelineResponse;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ObjectBuilder;
import java.util.HashMap;
import java.util.function.Function;
import javax.annotation.Nullable;

public class GetPipelineRequest
extends RequestBase {
    @Nullable
    private final String id;
    @Nullable
    private final Time masterTimeout;
    @Nullable
    private final Boolean summary;
    public static final Endpoint<GetPipelineRequest, GetPipelineResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<GetPipelineRequest, GetPipelineResponse>("es/ingest.get_pipeline", request -> "GET", request -> {
        boolean _id = true;
        boolean propsSet = false;
        if (request.id() != null) {
            propsSet |= true;
        }
        if (!propsSet) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_ingest");
            buf.append("/pipeline");
            return buf.toString();
        }
        if (propsSet) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_ingest");
            buf.append("/pipeline");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.id, buf);
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.masterTimeout != null) {
            params.put("master_timeout", request.masterTimeout._toJsonString());
        }
        if (request.summary != null) {
            params.put("summary", String.valueOf(request.summary));
        }
        return params;
    }, SimpleEndpoint.emptyMap(), false, GetPipelineResponse._DESERIALIZER);

    private GetPipelineRequest(Builder builder) {
        this.id = builder.id;
        this.masterTimeout = builder.masterTimeout;
        this.summary = builder.summary;
    }

    public static GetPipelineRequest of(Function<Builder, ObjectBuilder<GetPipelineRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final String id() {
        return this.id;
    }

    @Nullable
    public final Time masterTimeout() {
        return this.masterTimeout;
    }

    @Nullable
    public final Boolean summary() {
        return this.summary;
    }

    public static class Builder
    extends RequestBase.AbstractBuilder<Builder>
    implements ObjectBuilder<GetPipelineRequest> {
        @Nullable
        private String id;
        @Nullable
        private Time masterTimeout;
        @Nullable
        private Boolean summary;

        public final Builder id(@Nullable String value) {
            this.id = value;
            return this;
        }

        public final Builder masterTimeout(@Nullable Time value) {
            this.masterTimeout = value;
            return this;
        }

        public final Builder masterTimeout(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.masterTimeout(fn.apply(new Time.Builder()).build());
        }

        public final Builder summary(@Nullable Boolean value) {
            this.summary = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public GetPipelineRequest build() {
            this._checkSingleUse();
            return new GetPipelineRequest(this);
        }
    }
}

