/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.watcher;

import co.elastic.clients.elasticsearch.watcher.Condition;
import co.elastic.clients.elasticsearch.watcher.ConditionVariant;
import co.elastic.clients.json.JsonData;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.ObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class ScriptCondition
implements ConditionVariant,
JsonpSerializable {
    private final String lang;
    private final Map<String, JsonData> params;
    private final String source;
    public static final JsonpDeserializer<ScriptCondition> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ScriptCondition::setupScriptConditionDeserializer);

    private ScriptCondition(Builder builder) {
        this.lang = ApiTypeHelper.requireNonNull(builder.lang, this, "lang");
        this.params = ApiTypeHelper.unmodifiable(builder.params);
        this.source = ApiTypeHelper.requireNonNull(builder.source, this, "source");
    }

    public static ScriptCondition of(Function<Builder, ObjectBuilder<ScriptCondition>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Condition.Kind _conditionKind() {
        return Condition.Kind.Script;
    }

    public final String lang() {
        return this.lang;
    }

    public final Map<String, JsonData> params() {
        return this.params;
    }

    public final String source() {
        return this.source;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("lang");
        generator.write(this.lang);
        if (ApiTypeHelper.isDefined(this.params)) {
            generator.writeKey("params");
            generator.writeStartObject();
            for (Map.Entry<String, JsonData> item0 : this.params.entrySet()) {
                generator.writeKey(item0.getKey());
                item0.getValue().serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        generator.writeKey("source");
        generator.write(this.source);
    }

    protected static void setupScriptConditionDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::lang, JsonpDeserializer.stringDeserializer(), "lang");
        op.add(Builder::params, JsonpDeserializer.stringMapDeserializer(JsonData._DESERIALIZER), "params");
        op.add(Builder::source, JsonpDeserializer.stringDeserializer(), "source");
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<ScriptCondition> {
        private String lang;
        @Nullable
        private Map<String, JsonData> params;
        private String source;

        public final Builder lang(String value) {
            this.lang = value;
            return this;
        }

        public final Builder params(Map<String, JsonData> map) {
            this.params = Builder._mapPutAll(this.params, map);
            return this;
        }

        public final Builder params(String key, JsonData value) {
            this.params = Builder._mapPut(this.params, key, value);
            return this;
        }

        public final Builder source(String value) {
            this.source = value;
            return this;
        }

        @Override
        public ScriptCondition build() {
            this._checkSingleUse();
            return new ScriptCondition(this);
        }
    }
}

