/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.nodes.info;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.ObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class NodeInfoMemory
implements JsonpSerializable {
    private final String total;
    private final long totalInBytes;
    public static final JsonpDeserializer<NodeInfoMemory> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, NodeInfoMemory::setupNodeInfoMemoryDeserializer);

    private NodeInfoMemory(Builder builder) {
        this.total = ApiTypeHelper.requireNonNull(builder.total, this, "total");
        this.totalInBytes = ApiTypeHelper.requireNonNull(builder.totalInBytes, this, "totalInBytes");
    }

    public static NodeInfoMemory of(Function<Builder, ObjectBuilder<NodeInfoMemory>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String total() {
        return this.total;
    }

    public final long totalInBytes() {
        return this.totalInBytes;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("total");
        generator.write(this.total);
        generator.writeKey("total_in_bytes");
        generator.write(this.totalInBytes);
    }

    protected static void setupNodeInfoMemoryDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::total, JsonpDeserializer.stringDeserializer(), "total");
        op.add(Builder::totalInBytes, JsonpDeserializer.longDeserializer(), "total_in_bytes");
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<NodeInfoMemory> {
        private String total;
        private Long totalInBytes;

        public final Builder total(String value) {
            this.total = value;
            return this;
        }

        public final Builder totalInBytes(long value) {
            this.totalInBytes = value;
            return this;
        }

        @Override
        public NodeInfoMemory build() {
            this._checkSingleUse();
            return new NodeInfoMemory(this);
        }
    }
}

