/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.ObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class PostDataResponse
implements JsonpSerializable {
    private final long bucketCount;
    private final long earliestRecordTimestamp;
    private final long emptyBucketCount;
    private final long inputBytes;
    private final long inputFieldCount;
    private final long inputRecordCount;
    private final long invalidDateCount;
    private final String jobId;
    private final int lastDataTime;
    private final long latestRecordTimestamp;
    private final long missingFieldCount;
    private final long outOfOrderTimestampCount;
    private final long processedFieldCount;
    private final long processedRecordCount;
    private final long sparseBucketCount;
    public static final JsonpDeserializer<PostDataResponse> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, PostDataResponse::setupPostDataResponseDeserializer);

    private PostDataResponse(Builder builder) {
        this.bucketCount = ApiTypeHelper.requireNonNull(builder.bucketCount, this, "bucketCount");
        this.earliestRecordTimestamp = ApiTypeHelper.requireNonNull(builder.earliestRecordTimestamp, this, "earliestRecordTimestamp");
        this.emptyBucketCount = ApiTypeHelper.requireNonNull(builder.emptyBucketCount, this, "emptyBucketCount");
        this.inputBytes = ApiTypeHelper.requireNonNull(builder.inputBytes, this, "inputBytes");
        this.inputFieldCount = ApiTypeHelper.requireNonNull(builder.inputFieldCount, this, "inputFieldCount");
        this.inputRecordCount = ApiTypeHelper.requireNonNull(builder.inputRecordCount, this, "inputRecordCount");
        this.invalidDateCount = ApiTypeHelper.requireNonNull(builder.invalidDateCount, this, "invalidDateCount");
        this.jobId = ApiTypeHelper.requireNonNull(builder.jobId, this, "jobId");
        this.lastDataTime = ApiTypeHelper.requireNonNull(builder.lastDataTime, this, "lastDataTime");
        this.latestRecordTimestamp = ApiTypeHelper.requireNonNull(builder.latestRecordTimestamp, this, "latestRecordTimestamp");
        this.missingFieldCount = ApiTypeHelper.requireNonNull(builder.missingFieldCount, this, "missingFieldCount");
        this.outOfOrderTimestampCount = ApiTypeHelper.requireNonNull(builder.outOfOrderTimestampCount, this, "outOfOrderTimestampCount");
        this.processedFieldCount = ApiTypeHelper.requireNonNull(builder.processedFieldCount, this, "processedFieldCount");
        this.processedRecordCount = ApiTypeHelper.requireNonNull(builder.processedRecordCount, this, "processedRecordCount");
        this.sparseBucketCount = ApiTypeHelper.requireNonNull(builder.sparseBucketCount, this, "sparseBucketCount");
    }

    public static PostDataResponse of(Function<Builder, ObjectBuilder<PostDataResponse>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final long bucketCount() {
        return this.bucketCount;
    }

    public final long earliestRecordTimestamp() {
        return this.earliestRecordTimestamp;
    }

    public final long emptyBucketCount() {
        return this.emptyBucketCount;
    }

    public final long inputBytes() {
        return this.inputBytes;
    }

    public final long inputFieldCount() {
        return this.inputFieldCount;
    }

    public final long inputRecordCount() {
        return this.inputRecordCount;
    }

    public final long invalidDateCount() {
        return this.invalidDateCount;
    }

    public final String jobId() {
        return this.jobId;
    }

    public final int lastDataTime() {
        return this.lastDataTime;
    }

    public final long latestRecordTimestamp() {
        return this.latestRecordTimestamp;
    }

    public final long missingFieldCount() {
        return this.missingFieldCount;
    }

    public final long outOfOrderTimestampCount() {
        return this.outOfOrderTimestampCount;
    }

    public final long processedFieldCount() {
        return this.processedFieldCount;
    }

    public final long processedRecordCount() {
        return this.processedRecordCount;
    }

    public final long sparseBucketCount() {
        return this.sparseBucketCount;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("bucket_count");
        generator.write(this.bucketCount);
        generator.writeKey("earliest_record_timestamp");
        generator.write(this.earliestRecordTimestamp);
        generator.writeKey("empty_bucket_count");
        generator.write(this.emptyBucketCount);
        generator.writeKey("input_bytes");
        generator.write(this.inputBytes);
        generator.writeKey("input_field_count");
        generator.write(this.inputFieldCount);
        generator.writeKey("input_record_count");
        generator.write(this.inputRecordCount);
        generator.writeKey("invalid_date_count");
        generator.write(this.invalidDateCount);
        generator.writeKey("job_id");
        generator.write(this.jobId);
        generator.writeKey("last_data_time");
        generator.write(this.lastDataTime);
        generator.writeKey("latest_record_timestamp");
        generator.write(this.latestRecordTimestamp);
        generator.writeKey("missing_field_count");
        generator.write(this.missingFieldCount);
        generator.writeKey("out_of_order_timestamp_count");
        generator.write(this.outOfOrderTimestampCount);
        generator.writeKey("processed_field_count");
        generator.write(this.processedFieldCount);
        generator.writeKey("processed_record_count");
        generator.write(this.processedRecordCount);
        generator.writeKey("sparse_bucket_count");
        generator.write(this.sparseBucketCount);
    }

    protected static void setupPostDataResponseDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::bucketCount, JsonpDeserializer.longDeserializer(), "bucket_count");
        op.add(Builder::earliestRecordTimestamp, JsonpDeserializer.longDeserializer(), "earliest_record_timestamp");
        op.add(Builder::emptyBucketCount, JsonpDeserializer.longDeserializer(), "empty_bucket_count");
        op.add(Builder::inputBytes, JsonpDeserializer.longDeserializer(), "input_bytes");
        op.add(Builder::inputFieldCount, JsonpDeserializer.longDeserializer(), "input_field_count");
        op.add(Builder::inputRecordCount, JsonpDeserializer.longDeserializer(), "input_record_count");
        op.add(Builder::invalidDateCount, JsonpDeserializer.longDeserializer(), "invalid_date_count");
        op.add(Builder::jobId, JsonpDeserializer.stringDeserializer(), "job_id");
        op.add(Builder::lastDataTime, JsonpDeserializer.integerDeserializer(), "last_data_time");
        op.add(Builder::latestRecordTimestamp, JsonpDeserializer.longDeserializer(), "latest_record_timestamp");
        op.add(Builder::missingFieldCount, JsonpDeserializer.longDeserializer(), "missing_field_count");
        op.add(Builder::outOfOrderTimestampCount, JsonpDeserializer.longDeserializer(), "out_of_order_timestamp_count");
        op.add(Builder::processedFieldCount, JsonpDeserializer.longDeserializer(), "processed_field_count");
        op.add(Builder::processedRecordCount, JsonpDeserializer.longDeserializer(), "processed_record_count");
        op.add(Builder::sparseBucketCount, JsonpDeserializer.longDeserializer(), "sparse_bucket_count");
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<PostDataResponse> {
        private Long bucketCount;
        private Long earliestRecordTimestamp;
        private Long emptyBucketCount;
        private Long inputBytes;
        private Long inputFieldCount;
        private Long inputRecordCount;
        private Long invalidDateCount;
        private String jobId;
        private Integer lastDataTime;
        private Long latestRecordTimestamp;
        private Long missingFieldCount;
        private Long outOfOrderTimestampCount;
        private Long processedFieldCount;
        private Long processedRecordCount;
        private Long sparseBucketCount;

        public final Builder bucketCount(long value) {
            this.bucketCount = value;
            return this;
        }

        public final Builder earliestRecordTimestamp(long value) {
            this.earliestRecordTimestamp = value;
            return this;
        }

        public final Builder emptyBucketCount(long value) {
            this.emptyBucketCount = value;
            return this;
        }

        public final Builder inputBytes(long value) {
            this.inputBytes = value;
            return this;
        }

        public final Builder inputFieldCount(long value) {
            this.inputFieldCount = value;
            return this;
        }

        public final Builder inputRecordCount(long value) {
            this.inputRecordCount = value;
            return this;
        }

        public final Builder invalidDateCount(long value) {
            this.invalidDateCount = value;
            return this;
        }

        public final Builder jobId(String value) {
            this.jobId = value;
            return this;
        }

        public final Builder lastDataTime(int value) {
            this.lastDataTime = value;
            return this;
        }

        public final Builder latestRecordTimestamp(long value) {
            this.latestRecordTimestamp = value;
            return this;
        }

        public final Builder missingFieldCount(long value) {
            this.missingFieldCount = value;
            return this;
        }

        public final Builder outOfOrderTimestampCount(long value) {
            this.outOfOrderTimestampCount = value;
            return this;
        }

        public final Builder processedFieldCount(long value) {
            this.processedFieldCount = value;
            return this;
        }

        public final Builder processedRecordCount(long value) {
            this.processedRecordCount = value;
            return this;
        }

        public final Builder sparseBucketCount(long value) {
            this.sparseBucketCount = value;
            return this;
        }

        @Override
        public PostDataResponse build() {
            this._checkSingleUse();
            return new PostDataResponse(this);
        }
    }
}

