/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.indices.get_index_template;

import co.elastic.clients.elasticsearch.indices.get_index_template.IndexTemplateSummary;
import co.elastic.clients.json.JsonData;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.ObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class IndexTemplate
implements JsonpSerializable {
    private final List<String> indexPatterns;
    private final List<String> composedOf;
    @Nullable
    private final IndexTemplateSummary template;
    @Nullable
    private final Long version;
    @Nullable
    private final Long priority;
    private final Map<String, JsonData> meta;
    @Nullable
    private final Boolean allowAutoCreate;
    private final Map<String, JsonData> dataStream;
    public static final JsonpDeserializer<IndexTemplate> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, IndexTemplate::setupIndexTemplateDeserializer);

    private IndexTemplate(Builder builder) {
        this.indexPatterns = ApiTypeHelper.unmodifiableRequired(builder.indexPatterns, (Object)this, "indexPatterns");
        this.composedOf = ApiTypeHelper.unmodifiableRequired(builder.composedOf, (Object)this, "composedOf");
        this.template = builder.template;
        this.version = builder.version;
        this.priority = builder.priority;
        this.meta = ApiTypeHelper.unmodifiable(builder.meta);
        this.allowAutoCreate = builder.allowAutoCreate;
        this.dataStream = ApiTypeHelper.unmodifiable(builder.dataStream);
    }

    public static IndexTemplate of(Function<Builder, ObjectBuilder<IndexTemplate>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final List<String> indexPatterns() {
        return this.indexPatterns;
    }

    public final List<String> composedOf() {
        return this.composedOf;
    }

    @Nullable
    public final IndexTemplateSummary template() {
        return this.template;
    }

    @Nullable
    public final Long version() {
        return this.version;
    }

    @Nullable
    public final Long priority() {
        return this.priority;
    }

    public final Map<String, JsonData> meta() {
        return this.meta;
    }

    @Nullable
    public final Boolean allowAutoCreate() {
        return this.allowAutoCreate;
    }

    public final Map<String, JsonData> dataStream() {
        return this.dataStream;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (ApiTypeHelper.isDefined(this.indexPatterns)) {
            generator.writeKey("index_patterns");
            generator.writeStartArray();
            for (String string : this.indexPatterns) {
                generator.write(string);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.composedOf)) {
            generator.writeKey("composed_of");
            generator.writeStartArray();
            for (String string : this.composedOf) {
                generator.write(string);
            }
            generator.writeEnd();
        }
        if (this.template != null) {
            generator.writeKey("template");
            this.template.serialize(generator, mapper);
        }
        if (this.version != null) {
            generator.writeKey("version");
            generator.write(this.version.longValue());
        }
        if (this.priority != null) {
            generator.writeKey("priority");
            generator.write(this.priority.longValue());
        }
        if (ApiTypeHelper.isDefined(this.meta)) {
            generator.writeKey("_meta");
            generator.writeStartObject();
            for (Map.Entry entry : this.meta.entrySet()) {
                generator.writeKey((String)entry.getKey());
                ((JsonData)entry.getValue()).serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.allowAutoCreate != null) {
            generator.writeKey("allow_auto_create");
            generator.write(this.allowAutoCreate.booleanValue());
        }
        if (ApiTypeHelper.isDefined(this.dataStream)) {
            generator.writeKey("data_stream");
            generator.writeStartObject();
            for (Map.Entry entry : this.dataStream.entrySet()) {
                generator.writeKey((String)entry.getKey());
                ((JsonData)entry.getValue()).serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    protected static void setupIndexTemplateDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::indexPatterns, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "index_patterns");
        op.add(Builder::composedOf, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "composed_of");
        op.add(Builder::template, IndexTemplateSummary._DESERIALIZER, "template");
        op.add(Builder::version, JsonpDeserializer.longDeserializer(), "version");
        op.add(Builder::priority, JsonpDeserializer.longDeserializer(), "priority");
        op.add(Builder::meta, JsonpDeserializer.stringMapDeserializer(JsonData._DESERIALIZER), "_meta");
        op.add(Builder::allowAutoCreate, JsonpDeserializer.booleanDeserializer(), "allow_auto_create");
        op.add(Builder::dataStream, JsonpDeserializer.stringMapDeserializer(JsonData._DESERIALIZER), "data_stream");
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<IndexTemplate> {
        private List<String> indexPatterns;
        private List<String> composedOf;
        @Nullable
        private IndexTemplateSummary template;
        @Nullable
        private Long version;
        @Nullable
        private Long priority;
        @Nullable
        private Map<String, JsonData> meta;
        @Nullable
        private Boolean allowAutoCreate;
        @Nullable
        private Map<String, JsonData> dataStream;

        public final Builder indexPatterns(List<String> list) {
            this.indexPatterns = Builder._listAddAll(this.indexPatterns, list);
            return this;
        }

        public final Builder indexPatterns(String value, String ... values) {
            this.indexPatterns = Builder._listAdd(this.indexPatterns, value, values);
            return this;
        }

        public final Builder composedOf(List<String> list) {
            this.composedOf = Builder._listAddAll(this.composedOf, list);
            return this;
        }

        public final Builder composedOf(String value, String ... values) {
            this.composedOf = Builder._listAdd(this.composedOf, value, values);
            return this;
        }

        public final Builder template(@Nullable IndexTemplateSummary value) {
            this.template = value;
            return this;
        }

        public final Builder template(Function<IndexTemplateSummary.Builder, ObjectBuilder<IndexTemplateSummary>> fn) {
            return this.template(fn.apply(new IndexTemplateSummary.Builder()).build());
        }

        public final Builder version(@Nullable Long value) {
            this.version = value;
            return this;
        }

        public final Builder priority(@Nullable Long value) {
            this.priority = value;
            return this;
        }

        public final Builder meta(Map<String, JsonData> map) {
            this.meta = Builder._mapPutAll(this.meta, map);
            return this;
        }

        public final Builder meta(String key, JsonData value) {
            this.meta = Builder._mapPut(this.meta, key, value);
            return this;
        }

        public final Builder allowAutoCreate(@Nullable Boolean value) {
            this.allowAutoCreate = value;
            return this;
        }

        public final Builder dataStream(Map<String, JsonData> map) {
            this.dataStream = Builder._mapPutAll(this.dataStream, map);
            return this;
        }

        public final Builder dataStream(String key, JsonData value) {
            this.dataStream = Builder._mapPut(this.dataStream, key, value);
            return this;
        }

        @Override
        public IndexTemplate build() {
            this._checkSingleUse();
            return new IndexTemplate(this);
        }
    }
}

